<?php
 if (!tep_session_is_registered('customer_id')) {
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }
  require 'anet1/vendor/autoload.php';
  require_once  'anet1/samplecode/constants/Constants.php';
  use net\authorize\api\contract\v1 as AnetAPI;
  use net\authorize\api\controller as AnetController;

function chargeCreditCard($params)
{
	 
   /* Create a merchantAuthenticationType object with authentication details
       retrieved from the constants file */
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(\SampleCodeConstants::MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(\SampleCodeConstants::MERCHANT_TRANSACTION_KEY);
    $orders_id=$params['x_orders_id'];
	$amount =$params['x_amount'];
    // Set the transaction's refId
    $refId = 'ref' . time();

    // Create the payment data for a credit card
    $creditCard = new AnetAPI\CreditCardType();
   $creditCard->setCardNumber($params['x_card_num']);
    $creditCard->setExpirationDate($params['x_exp_date']);
    $creditCard->setCardCode($params['x_card_code']);
	
    // Add the payment data to a paymentType object
    $paymentOne = new AnetAPI\PaymentType();
    $paymentOne->setCreditCard($creditCard);

    // Create order information
    $order = new AnetAPI\OrderType();
	$order->setInvoiceNumber($params['x_invoice_num']);
   $order->setDescription($params['x_description']);

    // Set the customer's Bill To address
    $customerAddress = new AnetAPI\CustomerAddressType();
    $customerAddress->setFirstName($params['x_first_name']);
    $customerAddress->setLastName($params['x_last_name']);
    $customerAddress->setCompany($params['x_company']);
    $customerAddress->setAddress($params['x_address']);
    $customerAddress->setCity($params['x_city']);
    $customerAddress->setState($params['x_state']);
    $customerAddress->setZip($params['x_zip']);
    $customerAddress->setCountry($params['x_country']);

    // Set the customer's identifying information
    $customerData = new AnetAPI\CustomerDataType();
    $customerData->setType("individual");
   $customerData->setId($params['x_cust_id']);
    $customerData->setEmail($params['x_email']);

    // Add values for transaction settings
    $duplicateWindowSetting = new AnetAPI\SettingType();
    $duplicateWindowSetting->setSettingName("duplicateWindow");
    $duplicateWindowSetting->setSettingValue("60");

    // Add some merchant defined fields. These fields won't be stored with the transaction,
    // but will be echoed back in the response.
    $merchantDefinedField1 = new AnetAPI\UserFieldType();
    $merchantDefinedField1->setName("customerLoyaltyNum");
    $merchantDefinedField1->setValue("1128836273");

    $merchantDefinedField2 = new AnetAPI\UserFieldType();
    $merchantDefinedField2->setName("favoriteColor");
    $merchantDefinedField2->setValue("blue");

    // Create a TransactionRequestType object and add the previous objects to it
    $transactionRequestType = new AnetAPI\TransactionRequestType();
    $transactionRequestType->setTransactionType("authCaptureTransaction");
    $transactionRequestType->setAmount($amount);
    $transactionRequestType->setOrder($order);
    $transactionRequestType->setPayment($paymentOne);
    $transactionRequestType->setBillTo($customerAddress);
    $transactionRequestType->setCustomer($customerData);
    $transactionRequestType->addToTransactionSettings($duplicateWindowSetting);
    $transactionRequestType->addToUserFields($merchantDefinedField1);
    $transactionRequestType->addToUserFields($merchantDefinedField2);

    // Assemble the complete transaction request
    $request = new AnetAPI\CreateTransactionRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setRefId($refId);
    $request->setTransactionRequest($transactionRequestType);

    // Create the controller and get the response
    $controller = new AnetController\CreateTransactionController($request);
   //  $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);
    $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::PRODUCTION);

       if ($response != null) {
        // Check to see if the API request was successfully received and acted upon
        if ($response->getMessages()->getResultCode() == "Ok") {
            // Since the API request was successful, look for a transaction response
            // and parse it to display the results of authorizing the card
            $tresponse = $response->getTransactionResponse();
        
            if ($tresponse != null && $tresponse->getMessages() != null) {
             /*   echo " Successfully created transaction with Transaction ID: " . $tresponse->getTransId() . "\n";
                echo " Transaction Response Code: " . $tresponse->getResponseCode() . "\n";
                echo " Message Code: " . $tresponse->getMessages()[0]->getCode() . "\n";
                echo " Auth Code: " . $tresponse->getAuthCode() . "\n";
                echo " Description: " . $tresponse->getMessages()[0]->getDescription() . "\n";
				*/
				 $today = date("Y-m-d");  
					 $tran_id=$tresponse->getTransId();
					 $auth_code=$tresponse->getAuthCode();
					 $resp_message= $tresponse->getMessages()[0]->getDescription();
				$sql_data_array1 = array(
				                              'orders_id' => $orders_id,
											  'payment_amount' => $amount ,				                              
											  'payment_date' => $today,
											  'payment_method' => 'Credit Card',
											  'transaction_id'=> $tran_id,
											  'auth_code'=>$auth_code,
											  'response_message'=> $resp_message
											  );
		 tep_db_perform('orders_payments', $sql_data_array1);
				
tep_redirect("checkout_success_balance.php?status=completed", '', 'SSL');
	// tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS_BALANCE, '', 'SSL'));
	  //tep_redirect(tep_href_link("checkout_success_balance.php"));	

				
            } else {
               // echo "Transaction Failed \n";
                if ($tresponse->getErrors() != null) {
                    
					$errorCode=$tresponse->getErrors()[0]->getErrorCode() ;
				//	echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";
                //  echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";
					
                }
            }
            // Or, print errors if the API request wasn't successful
        } else {
           // echo "Transaction Failed \n";
            $tresponse = $response->getTransactionResponse();
        
            if ($tresponse != null && $tresponse->getErrors() != null) {
				$errorCode=$tresponse->getErrors()[0]->getErrorCode() ;
             //   echo " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "\n";
             //   echo " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "\n";
            } else {
				$errorCode=$response->getMessages()->getMessage()[0]->getCode() ;
              //  echo " Error Code  : " . $response->getMessages()->getMessage()[0]->getCode() . "\n";
               // echo " Error Message : " . $response->getMessages()->getMessage()[0]->getText() . "\n";
            }
        }
    } else {
		$errorCode="No response returned \n";
       // echo  "No response returned \n";
    }

    return $response;
}

/*													   
if (!defined('DONT_RUN_SAMPLES')) {
    chargeCreditCard("2.23");
}
*/
