<?php

/* http://www.sundesignworkshop.com */



////

// Get the installed version number

  function tep_get_version() {

    static $v;



    if (!isset($v)) {

      $v = trim(implode('', file(DIR_FS_CATALOG . 'includes/version.php')));

    }



    return $v;

  }



////

// Stop from parsing any further PHP code

  function tep_exit() {

   tep_session_close();

   exit();

  }



////

// Redirect to another page or site

  function tep_redirect($url) {

    if ( (strstr($url, "\n") != false) || (strstr($url, "\r") != false) ) { 

      tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));

    }



    if ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) { // We are loading an SSL page

      if (substr($url, 0, strlen(HTTP_SERVER)) == HTTP_SERVER) { // NONSSL url

        $url = HTTPS_SERVER . substr($url, strlen(HTTP_SERVER)); // Change it to SSL

      }

    }



    header('Location: ' . $url);



    tep_exit();

  }



////

// Parse the data used in the html tags to ensure the tags will not break

  function tep_parse_input_field_data($data, $parse) {

    return strtr(trim($data), $parse);

  }



  function tep_output_string($string, $translate = false, $protected = false) {

    if ($protected == true) {

      return htmlspecialchars($string);

    } else {

      if ($translate == false) {

        return tep_parse_input_field_data($string, array('"' => '&quot;'));

      } else {

        return tep_parse_input_field_data($string, $translate);

      }

    }

  }



  function tep_output_string_protected($string) {

    return tep_output_string($string, false, true);

  }



  function tep_sanitize_string($string) {

    $patterns = array ('/ +/','/[<>]/');

    $replace = array (' ', '_');

    return preg_replace($patterns, $replace, trim($string));

  }



////

// Return a random row from a database query

  function tep_random_select($query) {

    $random_product = '';

    $random_query = tep_db_query($query);

    $num_rows = tep_db_num_rows($random_query);

    if ($num_rows > 0) {

      $random_row = tep_rand(0, ($num_rows - 1));

      tep_db_data_seek($random_query, $random_row);

      $random_product = tep_db_fetch_array($random_query);

    }



    return $random_product;

  }



////

// Return a product's name

// TABLES: products

  function tep_get_products_name($product_id, $language = '') {

    global $languages_id;



    if (empty($language)) $language = $languages_id;



    $product_query = tep_db_query("select products_name from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language . "'");

    $product = tep_db_fetch_array($product_query);



    return $product['products_name'];

  }



////

// Return a product's special price (returns nothing if there is no offer)

// TABLES: products

  function tep_get_products_special_price($product_id) {

    $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status = 1");

    $product = tep_db_fetch_array($product_query);



    return $product['specials_new_products_price'];

  }



////

// Return a product's stock

// TABLES: products

  function tep_get_products_stock($products_id) {

    $products_id = tep_get_prid($products_id);

    $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . (int)$products_id . "'");

    $stock_values = tep_db_fetch_array($stock_query);



    return $stock_values['products_quantity'];

  }



////

// Check if the required stock is available

// If insufficent stock is available return an out of stock message

  function tep_check_stock($products_id, $products_quantity) {

    $stock_left = tep_get_products_stock($products_id) - $products_quantity;

    $out_of_stock = '';



    if ($stock_left < 0) {

      $out_of_stock = '<span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '</span>';

    }



    return $out_of_stock;

  }



////

// Break a word in a string if it is longer than a specified length ($len)

  function tep_break_string($string, $len, $break_char = '-') {

    $l = 0;

    $output = '';

    for ($i=0, $n=strlen($string); $i<$n; $i++) {

      $char = substr($string, $i, 1);

      if ($char != ' ') {

        $l++;

      } else {

        $l = 0;

      }

      if ($l > $len) {

        $l = 1;

        $output .= $break_char;

      }

      $output .= $char;

    }



    return $output;

  }



////

// Return all HTTP GET variables, except those passed as a parameter

  function tep_get_all_get_params($exclude_array = '') {

    global $HTTP_GET_VARS;



    if (!is_array($exclude_array)) $exclude_array = array();



    $get_url = '';

    if (is_array($HTTP_GET_VARS) && (sizeof($HTTP_GET_VARS) > 0)) {

      reset($HTTP_GET_VARS);

     foreach ($_GET as $key => $value) {

        if ( is_string($value) && (strlen($value) > 0) && ($key != tep_session_name()) && ($key != 'error') && (!in_array($key, $exclude_array)) && ($key != 'x') && ($key != 'y') ) {

          $get_url .= $key . '=' . rawurlencode(stripslashes($value)) . '&';

        }

      }

    }



    return $get_url;

  }



////

// Returns an array with countries

// TABLES: countries

  function tep_get_countries($countries_id = '', $with_iso_codes = false) {

    $countries_array = array();

    if (tep_not_null($countries_id)) {

      if ($with_iso_codes == true) {

        $countries = tep_db_query("select countries_name, countries_iso_code_2, countries_iso_code_3 from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$countries_id . "' order by countries_name");

        $countries_values = tep_db_fetch_array($countries);

        $countries_array = array('countries_name' => $countries_values['countries_name'],

                                 'countries_iso_code_2' => $countries_values['countries_iso_code_2'],

                                 'countries_iso_code_3' => $countries_values['countries_iso_code_3']);

      } else {

        $countries = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$countries_id . "'");

        $countries_values = tep_db_fetch_array($countries);

        $countries_array = array('countries_name' => $countries_values['countries_name']);

      }

    } else {

      $countries = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");

      while ($countries_values = tep_db_fetch_array($countries)) {

        $countries_array[] = array('countries_id' => $countries_values['countries_id'],

                                   'countries_name' => $countries_values['countries_name']);

      }

    }



    return $countries_array;

  }



////

// Alias function to tep_get_countries, which also returns the countries iso codes

  function tep_get_countries_with_iso_codes($countries_id) {

    return tep_get_countries($countries_id, true);

  }



////

// Generate a path to categories

  function tep_get_path($current_category_id = '') {

    global $cPath_array;



    if (tep_not_null($current_category_id)) {

      $cp_size = sizeof($cPath_array);

      if ($cp_size == 0) {

        $cPath_new = $current_category_id;

      } else {

        $cPath_new = '';

        $last_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$cPath_array[($cp_size-1)] . "'");

        $last_category = tep_db_fetch_array($last_category_query);



        $current_category_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");

        $current_category = tep_db_fetch_array($current_category_query);



        if ($last_category['parent_id'] == $current_category['parent_id']) {

          for ($i=0; $i<($cp_size-1); $i++) {

            $cPath_new .= '_' . $cPath_array[$i];

          }

        } else {

          for ($i=0; $i<$cp_size; $i++) {

            $cPath_new .= '_' . $cPath_array[$i];

          }

        }

        $cPath_new .= '_' . $current_category_id;



        if (substr($cPath_new, 0, 1) == '_') {

          $cPath_new = substr($cPath_new, 1);

        }

      }

    } else {

      $cPath_new = implode('_', $cPath_array);

    }



    return 'cPath=' . $cPath_new;

  }



////

// Returns the clients browser

  function tep_browser_detect($component) {

    global $HTTP_USER_AGENT;



    return stristr($HTTP_USER_AGENT, $component);

  }



////

// Alias function to tep_get_countries()

  function tep_get_country_name($country_id) {

    $country_array = tep_get_countries($country_id);



    return $country_array['countries_name'];

  }



////

// Returns the zone (State/Province) name

// TABLES: zones

  function tep_get_zone_name($country_id, $zone_id, $default_zone) {

    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");

    if (tep_db_num_rows($zone_query)) {

      $zone = tep_db_fetch_array($zone_query);

      return $zone['zone_name'];

    } else {

      return $default_zone;

    }

  }



////

// Returns the zone (State/Province) code

// TABLES: zones

  function tep_get_zone_code($country_id, $zone_id, $default_zone) {

    $zone_query = tep_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");

    if (tep_db_num_rows($zone_query)) {

      $zone = tep_db_fetch_array($zone_query);

      return $zone['zone_code'];

    } else {

      return $default_zone;

    }

  }



////

// Wrapper function for round()

  function tep_round($number, $precision) {

    if (strpos($number, '.') && (strlen(substr($number, strpos($number, '.')+1)) > $precision)) {

      $number = substr($number, 0, strpos($number, '.') + 1 + $precision + 1);



      if (substr($number, -1) >= 5) {

        if ($precision > 1) {

          $number = substr($number, 0, -1) + ('0.' . str_repeat(0, $precision-1) . '1');

        } elseif ($precision == 1) {

          $number = substr($number, 0, -1) + 0.1;

        } else {

          $number = substr($number, 0, -1) + 1;

        }

      } else {

        $number = substr($number, 0, -1);

      }

    }



    return $number;

  }



////

// Returns the tax rate for a zone / class

// TABLES: tax_rates, zones_to_geo_zones

  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {

    global $customer_zone_id, $customer_country_id;

    static $tax_rates = array();



    if ( ($country_id == -1) && ($zone_id == -1) ) {

      if (!tep_session_is_registered('customer_id')) {

        $country_id = STORE_COUNTRY;

        $zone_id = STORE_ZONE;

      } else {

        $country_id = $customer_country_id;

        $zone_id = $customer_zone_id;

      }

    }



    if (!isset($tax_rates[$class_id][$country_id][$zone_id]['rate'])) {

      $tax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' group by tr.tax_priority");

      if (tep_db_num_rows($tax_query)) {

        $tax_multiplier = 1.0;

        while ($tax = tep_db_fetch_array($tax_query)) {

          $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);

        }



        $tax_rates[$class_id][$country_id][$zone_id]['rate'] = ($tax_multiplier - 1.0) * 100;

      } else {

        $tax_rates[$class_id][$country_id][$zone_id]['rate'] = 0;

      }

    }



    return $tax_rates[$class_id][$country_id][$zone_id]['rate'];

  }



////

// Return the tax description for a zone / class

// TABLES: tax_rates;

  function tep_get_tax_description($class_id, $country_id, $zone_id) {

    static $tax_rates = array();



    if (!isset($tax_rates[$class_id][$country_id][$zone_id]['description'])) {

      $tax_query = tep_db_query("select tax_description from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' order by tr.tax_priority");

      if (tep_db_num_rows($tax_query)) {

        $tax_description = '';

        while ($tax = tep_db_fetch_array($tax_query)) {

          $tax_description .= $tax['tax_description'] . ' + ';

        }

        $tax_description = substr($tax_description, 0, -3);



        $tax_rates[$class_id][$country_id][$zone_id]['description'] = $tax_description;

      } else {

        $tax_rates[$class_id][$country_id][$zone_id]['description'] = TEXT_UNKNOWN_TAX_RATE;

      }

    }



    return $tax_rates[$class_id][$country_id][$zone_id]['description'];

  }



////

// Add tax to a products price

  function tep_add_tax($price, $tax) {

    if ( (DISPLAY_PRICE_WITH_TAX == 'true') && ($tax > 0) ) {

      return $price + tep_calculate_tax($price, $tax);

    } else {

      return $price;

    }

  }



// Calculates Tax rounding the result

  function tep_calculate_tax($price, $tax) {

    return $price * $tax / 100;

  }



////

// Return the number of products in a category

// TABLES: products, products_to_categories, categories

  function tep_count_products_in_category($category_id, $include_inactive = false) {

    $products_count = 0;

    if ($include_inactive == true) {

      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$category_id . "'");

    } else {

      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$category_id . "'");

    }

    $products = tep_db_fetch_array($products_query);

    $products_count += $products['total'];



    $child_categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$category_id . "'");

    if (tep_db_num_rows($child_categories_query)) {

      while ($child_categories = tep_db_fetch_array($child_categories_query)) {

        $products_count += tep_count_products_in_category($child_categories['categories_id'], $include_inactive);

      }

    }



    return $products_count;

  }



////

// Return true if the category has subcategories

// TABLES: categories

  function tep_has_category_subcategories($category_id) {

    $child_category_query = tep_db_query("select count(*) as count from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$category_id . "'");

    $child_category = tep_db_fetch_array($child_category_query);



    if ($child_category['count'] > 0) {

      return true;

    } else {

      return false;

    }

  }



////

// Returns the address_format_id for the given country

// TABLES: countries;

  function tep_get_address_format_id($country_id) {

    $address_format_query = tep_db_query("select address_format_id as format_id from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");

    if (tep_db_num_rows($address_format_query)) {

      $address_format = tep_db_fetch_array($address_format_query);

      return $address_format['format_id'];

    } else {

      return '1';

    }

  }



////

// Return a formatted address

// TABLES: address_format

  function tep_address_format($address_format_id, $address, $html, $boln, $eoln) {

    $address_format_query = tep_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . (int)$address_format_id . "'");

    $address_format = tep_db_fetch_array($address_format_query);



    $company = tep_output_string_protected($address['company']);

    if (isset($address['firstname']) && tep_not_null($address['firstname'])) {

      $firstname = tep_output_string_protected($address['firstname']);

      $lastname = tep_output_string_protected($address['lastname']);

    } elseif (isset($address['name']) && tep_not_null($address['name'])) {

      $firstname = tep_output_string_protected($address['name']);

      $lastname = '';

    } else {

      $firstname = '';

      $lastname = '';

    }

    $street = tep_output_string_protected($address['street_address']);

    $suburb = tep_output_string_protected($address['suburb']);

    $city = tep_output_string_protected($address['city']);

    $state = tep_output_string_protected($address['state']);

    if (isset($address['country_id']) && tep_not_null($address['country_id'])) {

      $country = tep_get_country_name($address['country_id']);



      if (isset($address['zone_id']) && tep_not_null($address['zone_id'])) {

        $state = tep_get_zone_code($address['country_id'], $address['zone_id'], $state);

      }

    } elseif (isset($address['country']) && tep_not_null($address['country'])) {

      $country = tep_output_string_protected($address['country']['title']);

    } else {

      $country = '';

    }

    $postcode = tep_output_string_protected($address['postcode']);

    $zip = $postcode;



    if ($html) {

// HTML Mode

      $HR = '<hr />';

      $hr = '<hr />';

      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults

        $CR = '<br />';

        $cr = '<br />';

        $eoln = $cr;

      } else { // Use values supplied

        $CR = $eoln . $boln;

        $cr = $CR;

      }

    } else {

// Text Mode

      $CR = $eoln;

      $cr = $CR;

      $HR = '----------------------------------------';

      $hr = '----------------------------------------';

    }



    $statecomma = '';

    $streets = $street;

    if ($suburb != '') $streets = $street . $cr . $suburb;

    if ($state != '') $statecomma = $state . ', ';



    $fmt = $address_format['format'];

    eval("\$address = \"$fmt\";");



    if ( (ACCOUNT_COMPANY == 'true') && (tep_not_null($company)) ) {

      $address = $company . $cr . $address;

    }



    return $address;

  }



////

// Return a formatted address

// TABLES: customers, address_book

  function tep_address_label($customers_id, $address_id = 1, $html = false, $boln = '', $eoln = "\n") {

    if (is_array($address_id) && !empty($address_id)) {

      return tep_address_format($address_id['address_format_id'], $address_id, $html, $boln, $eoln);

    }

    $address_query = tep_db_query("select entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customers_id . "' and address_book_id = '" . (int)$address_id . "'");

    $address = tep_db_fetch_array($address_query);



    $format_id = tep_get_address_format_id($address['country_id']);



    return tep_address_format($format_id, $address, $html, $boln, $eoln);

  }

  function tep_row_number_format($number) {
    if ( ($number < 10) && (substr($number, 0, 1) != '0') ) $number = '0' . $number;
    return $number;
  }
 

  function tep_get_manufacturers($manufacturers_array = '') {

    if (!is_array($manufacturers_array)) $manufacturers_array = array();

    $manufacturers_query = tep_db_query("select manufacturers_id, manufacturers_name from " . TABLE_MANUFACTURERS . " order by manufacturers_name");

    while ($manufacturers = tep_db_fetch_array($manufacturers_query)) {

      $manufacturers_array[] = array('id' => $manufacturers['manufacturers_id'], 'text' => $manufacturers['manufacturers_name']);

    }
    return $manufacturers_array;

  }

////

// Return all subcategory IDs

// TABLES: categories

  function tep_get_subcategories(&$subcategories_array, $parent_id = 0) {

    $subcategories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$parent_id . "'");

    while ($subcategories = tep_db_fetch_array($subcategories_query)) {

      $subcategories_array[sizeof($subcategories_array)] = $subcategories['categories_id'];

      if ($subcategories['categories_id'] != $parent_id) {

        tep_get_subcategories($subcategories_array, $subcategories['categories_id']);

      }

    }

  }



// Output a raw date string in the selected locale date format

// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS

  function tep_date_long($raw_date) {

    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;



    $year = (int)substr($raw_date, 0, 4);

    $month = (int)substr($raw_date, 5, 2);

    $day = (int)substr($raw_date, 8, 2);

    $hour = (int)substr($raw_date, 11, 2);

    $minute = (int)substr($raw_date, 14, 2);

    $second = (int)substr($raw_date, 17, 2);



    return strftime(DATE_FORMAT_LONG, mktime($hour,$minute,$second,$month,$day,$year));

  }



////

// Output a raw date string in the selected locale date format

// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS

// NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers

  function tep_date_short($raw_date) {

    if ( ($raw_date == '0000-00-00 00:00:00') || empty($raw_date) ) return false;



    $year = substr($raw_date, 0, 4);

    $month = (int)substr($raw_date, 5, 2);

    $day = (int)substr($raw_date, 8, 2);

    $hour = (int)substr($raw_date, 11, 2);

    $minute = (int)substr($raw_date, 14, 2);

    $second = (int)substr($raw_date, 17, 2);



    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {

      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));

    } else {

      return preg_replace('/2037$/', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));

    }

  }



////

// Parse search string into indivual objects

  function tep_parse_search_string($search_str = '', &$objects) {

    $search_str = trim(strtolower($search_str));



// Break up $search_str on whitespace; quoted string will be reconstructed later

    $pieces = preg_split('/[[:space:]]+/', $search_str);

    $objects = array();

    $tmpstring = '';

    $flag = '';



    for ($k=0; $k<count($pieces); $k++) {

      while (substr($pieces[$k], 0, 1) == '(') {

        $objects[] = '(';

        if (strlen($pieces[$k]) > 1) {

          $pieces[$k] = substr($pieces[$k], 1);

        } else {

          $pieces[$k] = '';

        }

      }



      $post_objects = array();



      while (substr($pieces[$k], -1) == ')')  {

        $post_objects[] = ')';

        if (strlen($pieces[$k]) > 1) {

          $pieces[$k] = substr($pieces[$k], 0, -1);

        } else {

          $pieces[$k] = '';

        }

      }



// Check individual words



      if ( (substr($pieces[$k], -1) != '"') && (substr($pieces[$k], 0, 1) != '"') ) {

        $objects[] = trim($pieces[$k]);



        for ($j=0; $j<count($post_objects); $j++) {

          $objects[] = $post_objects[$j];

        }

      } else {

/* This means that the $piece is either the beginning or the end of a string.

   So, we'll slurp up the $pieces and stick them together until we get to the

   end of the string or run out of pieces.

*/



// Add this word to the $tmpstring, starting the $tmpstring

        $tmpstring = trim(preg_replace('/"/', ' ', $pieces[$k]));



// Check for one possible exception to the rule. That there is a single quoted word.

        if (substr($pieces[$k], -1 ) == '"') {

// Turn the flag off for future iterations

          $flag = 'off';



          $objects[] = trim(preg_replace('/"/', ' ', $pieces[$k]));



          for ($j=0; $j<count($post_objects); $j++) {

            $objects[] = $post_objects[$j];

          }



          unset($tmpstring);



// Stop looking for the end of the string and move onto the next word.

          continue;

        }



// Otherwise, turn on the flag to indicate no quotes have been found attached to this word in the string.

        $flag = 'on';



// Move on to the next word

        $k++;



// Keep reading until the end of the string as long as the $flag is on



        while ( ($flag == 'on') && ($k < count($pieces)) ) {

          while (substr($pieces[$k], -1) == ')') {

            $post_objects[] = ')';

            if (strlen($pieces[$k]) > 1) {

              $pieces[$k] = substr($pieces[$k], 0, -1);

            } else {

              $pieces[$k] = '';

            }

          }



// If the word doesn't end in double quotes, append it to the $tmpstring.

          if (substr($pieces[$k], -1) != '"') {

// Tack this word onto the current string entity

            $tmpstring .= ' ' . $pieces[$k];



// Move on to the next word

            $k++;

            continue;

          } else {

/* If the $piece ends in double quotes, strip the double quotes, tack the

   $piece onto the tail of the string, push the $tmpstring onto the $haves,

   kill the $tmpstring, turn the $flag "off", and return.

*/

            $tmpstring .= ' ' . trim(preg_replace('/"/', ' ', $pieces[$k]));



// Push the $tmpstring onto the array of stuff to search for

            $objects[] = trim($tmpstring);



            for ($j=0; $j<count($post_objects); $j++) {

              $objects[] = $post_objects[$j];

            }



            unset($tmpstring);



// Turn off the flag to exit the loop

            $flag = 'off';

          }

        }

      }

    }



// add default logical operators if needed

    $temp = array();

    for($i=0; $i<(count($objects)-1); $i++) {

      $temp[] = $objects[$i];

      if ( ($objects[$i] != 'and') &&

           ($objects[$i] != 'or') &&

           ($objects[$i] != '(') &&

           ($objects[$i+1] != 'and') &&

           ($objects[$i+1] != 'or') &&

           ($objects[$i+1] != ')') ) {

        $temp[] = ADVANCED_SEARCH_DEFAULT_OPERATOR;

      }

    }

    $temp[] = $objects[$i];

    $objects = $temp;



    $keyword_count = 0;

    $operator_count = 0;

    $balance = 0;

    for($i=0; $i<count($objects); $i++) {

      if ($objects[$i] == '(') $balance --;

      if ($objects[$i] == ')') $balance ++;

      if ( ($objects[$i] == 'and') || ($objects[$i] == 'or') ) {

        $operator_count ++;

      } elseif ( ($objects[$i]) && ($objects[$i] != '(') && ($objects[$i] != ')') ) {

        $keyword_count ++;

      }

    }



    if ( ($operator_count < $keyword_count) && ($balance == 0) ) {

      return true;

    } else {

      return false;

    }

  }



////

// Check date

  function tep_checkdate($date_to_check, $format_string, &$date_array) {

    $separator_idx = -1;



    $separators = array('-', ' ', '/', '.');

    $month_abbr = array('jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec');

    $no_of_days = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);



    $format_string = strtolower($format_string);



    if (strlen($date_to_check) != strlen($format_string)) {

      return false;

    }



    $size = sizeof($separators);

    for ($i=0; $i<$size; $i++) {

      $pos_separator = strpos($date_to_check, $separators[$i]);

      if ($pos_separator != false) {

        $date_separator_idx = $i;

        break;

      }

    }



    for ($i=0; $i<$size; $i++) {

      $pos_separator = strpos($format_string, $separators[$i]);

      if ($pos_separator != false) {

        $format_separator_idx = $i;

        break;

      }

    }



    if ($date_separator_idx != $format_separator_idx) {

      return false;

    }



    if ($date_separator_idx != -1) {

      $format_string_array = explode( $separators[$date_separator_idx], $format_string );

      if (sizeof($format_string_array) != 3) {

        return false;

      }



      $date_to_check_array = explode( $separators[$date_separator_idx], $date_to_check );

      if (sizeof($date_to_check_array) != 3) {

        return false;

      }



      $size = sizeof($format_string_array);

      for ($i=0; $i<$size; $i++) {

        if ($format_string_array[$i] == 'mm' || $format_string_array[$i] == 'mmm') $month = $date_to_check_array[$i];

        if ($format_string_array[$i] == 'dd') $day = $date_to_check_array[$i];

        if ( ($format_string_array[$i] == 'yyyy') || ($format_string_array[$i] == 'aaaa') ) $year = $date_to_check_array[$i];

      }

    } else {

      if (strlen($format_string) == 8 || strlen($format_string) == 9) {

        $pos_month = strpos($format_string, 'mmm');

        if ($pos_month != false) {

          $month = substr( $date_to_check, $pos_month, 3 );

          $size = sizeof($month_abbr);

          for ($i=0; $i<$size; $i++) {

            if ($month == $month_abbr[$i]) {

              $month = $i;

              break;

            }

          }

        } else {

          $month = substr($date_to_check, strpos($format_string, 'mm'), 2);

        }

      } else {

        return false;

      }



      $day = substr($date_to_check, strpos($format_string, 'dd'), 2);

      $year = substr($date_to_check, strpos($format_string, 'yyyy'), 4);

    }



    if (strlen($year) != 4) {

      return false;

    }



    if (!settype($year, 'integer') || !settype($month, 'integer') || !settype($day, 'integer')) {

      return false;

    }



    if ($month > 12 || $month < 1) {

      return false;

    }



    if ($day < 1) {

      return false;

    }



    if (tep_is_leap_year($year)) {

      $no_of_days[1] = 29;

    }



    if ($day > $no_of_days[$month - 1]) {

      return false;

    }



    $date_array = array($year, $month, $day);



    return true;

  }



////

// Check if year is a leap year

  function tep_is_leap_year($year) {

    if ($year % 100 == 0) {

      if ($year % 400 == 0) return true;

    } else {

      if (($year % 4) == 0) return true;

    }



    return false;

  }



////

// Return table heading with sorting capabilities

  function tep_create_sort_heading($sortby, $colnum, $heading) {

    global $PHP_SELF;



    $sort_prefix = '';

    $sort_suffix = '';



    if ($sortby) {

      $sort_prefix = '<a href="' . tep_href_link(basename($PHP_SELF), tep_get_all_get_params(array('page', 'info', 'sort')) . 'page=1&sort=' . $colnum . ($sortby == $colnum . 'a' ? 'd' : 'a')) . '" title="' . tep_output_string(TEXT_SORT_PRODUCTS . ($sortby == $colnum . 'd' || substr($sortby, 0, 1) != $colnum ? TEXT_ASCENDINGLY : TEXT_DESCENDINGLY) . TEXT_BY . $heading) . '" class="productListing-heading">' ;

      $sort_suffix = (substr($sortby, 0, 1) == $colnum ? (substr($sortby, 1, 1) == 'a' ? '+' : '-') : '') . '</a>';

    }



    return $sort_prefix . $heading . $sort_suffix;

  }



////

// Recursively go through the categories and retreive all parent categories IDs

// TABLES: categories

  function tep_get_parent_categories(&$categories, $categories_id) {

    $parent_categories_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$categories_id . "'");

    while ($parent_categories = tep_db_fetch_array($parent_categories_query)) {

      if ($parent_categories['parent_id'] == 0) return true;

      $categories[sizeof($categories)] = $parent_categories['parent_id'];

      if ($parent_categories['parent_id'] != $categories_id) {

        tep_get_parent_categories($categories, $parent_categories['parent_id']);

      }

    }

  }



////

// Construct a category path to the product

// TABLES: products_to_categories

  function tep_get_product_path($products_id) {

    $cPath = '';



    $category_query = tep_db_query("select p2c.categories_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = '" . (int)$products_id . "' and p.products_status = '1' and p.products_id = p2c.products_id limit 1");

    if (tep_db_num_rows($category_query)) {

      $category = tep_db_fetch_array($category_query);



      $categories = array();

      tep_get_parent_categories($categories, $category['categories_id']);



      $categories = array_reverse($categories);



      $cPath = implode('_', $categories);



      if (tep_not_null($cPath)) $cPath .= '_';

      $cPath .= $category['categories_id'];

    }



    return $cPath;

  }



////

// Return a product ID with attributes

  function tep_get_uprid($prid, $params) {

    if (is_numeric($prid)) {

      $uprid = (int)$prid;



      if (is_array($params) && (sizeof($params) > 0)) {

        $attributes_check = true;

        $attributes_ids = '';



        reset($params);

        foreach ($params as $option => $value) {

          if (is_numeric($option) && is_numeric($value)) {

            $attributes_ids .= '{' . (int)$option . '}' . (int)$value;

          } else {

            $attributes_check = false;

            break;

          }

        }



        if ($attributes_check == true) {

          $uprid .= $attributes_ids;

        }

      }

    } else {

      $uprid = tep_get_prid($prid);



      if (is_numeric($uprid)) {

        if (strpos($prid, '{') !== false) {

          $attributes_check = true;

          $attributes_ids = '';



// strpos()+1 to remove up to and including the first { which would create an empty array element in explode()

          $attributes = explode('{', substr($prid, strpos($prid, '{')+1));



          for ($i=0, $n=sizeof($attributes); $i<$n; $i++) {

            $pair = explode('}', $attributes[$i]);



            if (is_numeric($pair[0]) && is_numeric($pair[1])) {

              $attributes_ids .= '{' . (int)$pair[0] . '}' . (int)$pair[1];

            } else {

              $attributes_check = false;

              break;

            }

          }



          if ($attributes_check == true) {

            $uprid .= $attributes_ids;

          }

        }

      } else {

        return false;

      }

    }



    return $uprid;

  }



////

// Return a product ID from a product ID with attributes

  function tep_get_prid($uprid) {

    $pieces = explode('{', $uprid);



    if (is_numeric($pieces[0])) {

      return (int)$pieces[0];

    } else {

      return false;

    }

  }



////

// Return a customer greeting

  function tep_customer_greeting() {

    global $customer_id, $customer_first_name;



    if (tep_session_is_registered('customer_first_name') && tep_session_is_registered('customer_id')) {

      $greeting_string = sprintf(TEXT_GREETING_PERSONAL, tep_output_string_protected($customer_first_name), tep_href_link(FILENAME_PRODUCTS_NEW));

    } else {

      $greeting_string = sprintf(TEXT_GREETING_GUEST, tep_href_link(FILENAME_LOGIN, '', 'SSL'), tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));

    }



    return $greeting_string;

  }



////

//! Send email (text/html) using MIME

// This is the central mail function. The SMTP Server should be configured

// correct in php.ini

// Parameters:

// $to_name           The name of the recipient, e.g. "Jan Wildeboer"

// $to_email_address  The eMail address of the recipient,

//                    e.g. jan.wildeboer@gmx.de

// $email_subject     The subject of the eMail

// $email_text        The text of the eMail, may contain HTML entities

// $from_email_name   The name of the sender, e.g. Shop Administration

// $from_email_adress The eMail address of the sender,

//                    e.g. info@mytepshop.com



  function tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address) {

    if (SEND_EMAILS != 'true') return false;



    // Instantiate a new mail object

    $message = new email(array('X-Mailer: osCommerce'));



    // Build the text version

    $text = strip_tags($email_text);

    if (EMAIL_USE_HTML == 'true') {

      $message->add_html($email_text, $text);

    } else {

      $message->add_text($text);

    }



    // Send message

    $message->build_message();

    $message->send($to_name, $to_email_address, $from_email_name, $from_email_address, $email_subject);

  }



////

// Check if product has attributes

  function tep_has_product_attributes($products_id) {

    $attributes_query = tep_db_query("select count(*) as count from " . TABLE_PRODUCTS_ATTRIBUTES . " where products_id = '" . (int)$products_id . "'");

    $attributes = tep_db_fetch_array($attributes_query);



    if ($attributes['count'] > 0) {

      return true;

    } else {

      return false;

    }

  }



////

// Get the number of times a word/character is present in a string

  function tep_word_count($string, $needle) {

    $temp_array = preg_split('/' . $needle . '/', $string);



    return sizeof($temp_array);

  }



  function tep_count_modules($modules = '') {

    $count = 0;



    if (empty($modules)) return $count;



    $modules_array = explode(';', $modules);



    for ($i=0, $n=sizeof($modules_array); $i<$n; $i++) {

      $class = substr($modules_array[$i], 0, strrpos($modules_array[$i], '.'));



      if (isset($GLOBALS[$class]) && is_object($GLOBALS[$class])) {

        if ($GLOBALS[$class]->enabled) {

          $count++;

        }

      }

    }



    return $count;

  }



  function tep_count_payment_modules() {

    return tep_count_modules(MODULE_PAYMENT_INSTALLED);

  }



  function tep_count_shipping_modules() {

    return tep_count_modules(MODULE_SHIPPING_INSTALLED);

  }



  function tep_create_random_value($length, $type = 'mixed') {

    if ( ($type != 'mixed') && ($type != 'chars') && ($type != 'digits')) return false;



    $rand_value = '';

    while (strlen($rand_value) < $length) {

      if ($type == 'digits') {

        $char = tep_rand(0,9);

      } else {

        $char = chr(tep_rand(0,255));

      }

      if ($type == 'mixed') {

        if (preg_match('/^[a-z0-9]$/i', $char)) $rand_value .= $char;

      } elseif ($type == 'chars') {

        if (preg_match('/^[a-z]$/i', $char)) $rand_value .= $char;

      } elseif ($type == 'digits') {

        if (preg_match('/^[0-9]$/i', $char)) $rand_value .= $char;

      }

    }



    return $rand_value;

  }



  function tep_array_to_string($array, $exclude = '', $equals = '=', $separator = '&') {

    if (!is_array($exclude)) $exclude = array();



    $get_string = '';

    if (sizeof($array) > 0) {

      foreach ($array as $key => $value) {

        if ( (!in_array($key, $exclude)) && ($key != 'x') && ($key != 'y') ) {

          $get_string .= $key . $equals . $value . $separator;

        }

      }

      $remove_chars = strlen($separator);

      $get_string = substr($get_string, 0, -$remove_chars);

    }



    return $get_string;

  }



  function tep_not_null($value) {

    if (is_array($value)) {

      if (sizeof($value) > 0) {

        return true;

      } else {

        return false;

      }

    } else {

      if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {

        return true;

      } else {

        return false;

      }

    }

  }



////

// Output the tax percentage with optional padded decimals

  function tep_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {

    if (strpos($value, '.')) {

      $loop = true;

      while ($loop) {

        if (substr($value, -1) == '0') {

          $value = substr($value, 0, -1);

        } else {

          $loop = false;

          if (substr($value, -1) == '.') {

            $value = substr($value, 0, -1);

          }

        }

      }

    }



    if ($padding > 0) {

      if ($decimal_pos = strpos($value, '.')) {

        $decimals = strlen(substr($value, ($decimal_pos+1)));

        for ($i=$decimals; $i<$padding; $i++) {

          $value .= '0';

        }

      } else {

        $value .= '.';

        for ($i=0; $i<$padding; $i++) {

          $value .= '0';

        }

      }

    }



    return $value;

  }



////

// Checks to see if the currency code exists as a currency

// TABLES: currencies

  function tep_currency_exists($code) {

    $code = tep_db_prepare_input($code);



    $currency_query = tep_db_query("select code from " . TABLE_CURRENCIES . " where code = '" . tep_db_input($code) . "' limit 1");

    if (tep_db_num_rows($currency_query)) {

      $currency = tep_db_fetch_array($currency_query);

      return $currency['code'];

    } else {

      return false;

    }

  }



  function tep_string_to_int($string) {

    return (int)$string;

  }



////

// Parse and secure the cPath parameter values

  function tep_parse_category_path($cPath) {

// make sure the category IDs are integers

    $cPath_array = array_map('tep_string_to_int', explode('_', $cPath));



// make sure no duplicate category IDs exist which could lock the server in a loop

    $tmp_array = array();

    $n = sizeof($cPath_array);

    for ($i=0; $i<$n; $i++) {

      if (!in_array($cPath_array[$i], $tmp_array)) {

        $tmp_array[] = $cPath_array[$i];

      }

    }



    return $tmp_array;

  }



////

// Return a random value

  function tep_rand($min = null, $max = null) {

    static $seeded;



    if (!isset($seeded)) {

      mt_srand((double)microtime()*1000000);

      $seeded = true;

    }



    if (isset($min) && isset($max)) {

      if ($min >= $max) {

        return $min;

      } else {

        return mt_rand($min, $max);

      }

    } else {

      return mt_rand();

    }

  }



  function tep_setcookie($name, $value = '', $expire = 0, $path = '/', $domain = '', $secure = 0) {

    setcookie($name, $value, $expire, $path, (tep_not_null($domain) ? $domain : ''), $secure);

  }



  function tep_validate_ip_address($ip_address) {

    if (function_exists('filter_var') && defined('FILTER_VALIDATE_IP')) {

      return filter_var($ip_address, FILTER_VALIDATE_IP, array('flags' => FILTER_FLAG_IPV4));

    }



    if (preg_match('/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/', $ip_address)) {

      $parts = explode('.', $ip_address);



      foreach ($parts as $ip_parts) {

        if ( (intval($ip_parts) > 255) || (intval($ip_parts) < 0) ) {

          return false; // number is not within 0-255

        }

      }



      return true;

    }



    return false;

  }



  function tep_get_ip_address() {

    global $HTTP_SERVER_VARS;



    $ip_address = null;

    $ip_addresses = array();



    if (isset($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR']) && !empty($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'])) {

      foreach ( array_reverse(explode(',', $HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'])) as $x_ip ) {

        $x_ip = trim($x_ip);



        if (tep_validate_ip_address($x_ip)) {

          $ip_addresses[] = $x_ip;

        }

      }

    }



    if (isset($HTTP_SERVER_VARS['HTTP_CLIENT_IP']) && !empty($HTTP_SERVER_VARS['HTTP_CLIENT_IP'])) {

      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_CLIENT_IP'];

    }



    if (isset($HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP']) && !empty($HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP'])) {

      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_X_CLUSTER_CLIENT_IP'];

    }



    if (isset($HTTP_SERVER_VARS['HTTP_PROXY_USER']) && !empty($HTTP_SERVER_VARS['HTTP_PROXY_USER'])) {

      $ip_addresses[] = $HTTP_SERVER_VARS['HTTP_PROXY_USER'];

    }



    $ip_addresses[] = $HTTP_SERVER_VARS['REMOTE_ADDR'];



    foreach ( $ip_addresses as $ip ) {

      if (!empty($ip) && tep_validate_ip_address($ip)) {

        $ip_address = $ip;

        break;

      }

    }



    return $ip_address;

  }



  function tep_count_customer_orders($id = '', $check_session = true) {

    global $customer_id, $languages_id;



    if (is_numeric($id) == false) {

      if (tep_session_is_registered('customer_id')) {

        $id = $customer_id;

      } else {

        return 0;

      }

    }



    if ($check_session == true) {

      if ( (tep_session_is_registered('customer_id') == false) || ($id != $customer_id) ) {

        return 0;

      }

    }



    $orders_check_query = tep_db_query("select count(*) as total from " . TABLE_ORDERS . " o, " . TABLE_ORDERS_STATUS . " s where o.customers_id = '" . (int)$id . "' and o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and s.public_flag = '1'");

    $orders_check = tep_db_fetch_array($orders_check_query);



    return $orders_check['total'];

  }



  function tep_count_customer_address_book_entries($id = '', $check_session = true) {

    global $customer_id;



    if (is_numeric($id) == false) {

      if (tep_session_is_registered('customer_id')) {

        $id = $customer_id;

      } else {

        return 0;

      }

    }



    if ($check_session == true) {

      if ( (tep_session_is_registered('customer_id') == false) || ($id != $customer_id) ) {

        return 0;

      }

    }



    $addresses_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$id . "'");

    $addresses = tep_db_fetch_array($addresses_query);



    return $addresses['total'];

  }



// nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)

  function tep_convert_linefeeds($from, $to, $string) {

    if ((PHP_VERSION < "4.0.5") && is_array($from)) {

      return preg_replace('/(' . implode('|', $from) . ')/', $to, $string);

    } else {

      return str_replace($from, $to, $string);

    }

  }

  

  ////

// Returns an array with day_schools

// TABLES: schools

  function tep_get_day_schools( ) {

    $day_schools_array = array();

      $day_schools = tep_db_query("select day_schools_id, day_schools_name from " . TABLE_DAY_SCHOOLS . " where school_status='Active' order by day_schools_name");

      while ($day_schools_values = tep_db_fetch_array($day_schools)) {

        $day_schools_array[] = array('day_schools_id' => $day_schools_values['day_schools_id'],

                                   'day_schools_name' => $day_schools_values['day_schools_name']);

      }



    return $day_schools_array;

  }

  // Return a product's name

// TABLES: products

  function tep_get_day_schools_products_name($day_schools_id,$grade) {

	  $today= date('m-d-Y');

	 if($grade=='K'&&$today<'09-22-2010'){

		      $product_query = tep_db_query("SELECT classes_name, classes.classes_id, tuition, schedules_types_id

FROM classes, day_schools

WHERE  classes.short_day_status='K'

AND day_schools.day_schools_id = '" .$day_schools_id . "'

GROUP BY classes_name, classes.classes_id, tuition, schedules_types_id");

		 }

		 else{

			  $product_query = tep_db_query("SELECT classes_name, classes.classes_id, tuition, schedules_types_id

FROM classes, day_schools

WHERE day_schools.short_day_status = classes.short_day_status

AND day_schools.day_schools_id = '" .$day_schools_id . "'

GROUP BY classes_name, classes.classes_id, tuition, schedules_types_id");

    //$product_query = tep_db_query("SELECT classes_name, classes.classes_id, tuition, schedules_types_id

//FROM classes, classes_day_schools,day_schools

//WHERE classes.classes_id = classes_day_schools.classes_id

//And day_schools.short_day_status = classes.short_day_status

//AND classes_day_schools.day_schools_id= '" .$day_schools_id . "' group by classes_name, classes.classes_id, tuition, schedules_types_id");

		 }

  while (  $product = tep_db_fetch_array($product_query)) {

        $day_schools_products_array[] = array('classes_id' => $product['classes_id'],

											'classes_name' => $product['classes_name'].' $'.$product['tuition']);

      }

    return $day_schools_products_array;

  

  }

  

   ////

// Returns an array with students in a family

// TABLES: students families customers

  function tep_get_family_students($families_id ) {

    $family_students_array = array();
	
      $family_students = tep_db_query("select * from customers, families, students where customers.families_id=families.families_id and students.families_id=families.families_id  and  customers.families_id='" .$families_id . "'");

      while ($family_students_values = tep_db_fetch_array($family_students)) {

        $family_students_array[] = array('families_id' => $family_students_values['families_id'], 

										'families_name' => $family_students_values['families_name'],

										'students_first_name' => $family_students_values['students_first_name'],

										'students_last_name' => $family_students_values['students_last_name'],

										'grade' => $family_students_values['grade'],

										'day_schools_name' => $family_students_values['day_schools_name'],

										 'students_status' => $family_students_values['students_status'],
										
										 'agreement_link' => $family_students_values['agreement_link'],
										 'registration_fee_paid' => $family_students_values['registration_fee_paid'],

									   'students_id' => $family_students_values['students_id']);
      }
    return $family_students_array;
  }



   // Return a product's name

// TABLES: products

  function tep_get_schedule_types() {

	 

    $product_query = tep_db_query("SELECT * from schedule_types");

  while (  $product = tep_db_fetch_array($product_query)) {

        $day_schools_products_array[] = array('schedule_types_id' => $product['schedule_types_id'],

											'schedule_types' => $product['schedule_types']);

      }

    return $day_schools_products_array;

  

  }

  function add_schedule($classes_id,$students_id,$schedule_types_id,$mds) {

      global  $customer_id;

	  $tuition=get_tuition($classes_id);

            if (tep_session_is_registered('customer_id')) tep_db_query("insert into enrollments(customers_id, classes_id,students_id, tuition, enrollment_date,schedule_types_id,meeting_days) values ('" . (int)$customer_id . "', '" . tep_db_input($classes_id) . "', '" . tep_db_input($students_id) . "',  '" . tep_db_input($tuition) . "','" . date('Ymd') . "','". tep_db_input($schedule_types_id)."', '" . tep_db_input($mds) . "')");

		

 return $enrollments_id = tep_db_insert_id();

    }

	

  function add_summer_schedule($classes_id,$students_id,$mds,$tuition,$lunchTotal,$material_fee,$schedule_types_id,$total,$summer_pickup_locations_id,$discount,$registration_fee=0) {

      global  $customer_id;
	
if ($lunchTotal>0) 
               $order_all_lunches='Y';
          else
                 $order_all_lunches='N';

            if (tep_session_is_registered('customer_id')) 
				tep_db_query("insert into enrollments(customers_id, classes_id,students_id, tuition,lunch_total,material_fee, enrollment_date,meeting_days,schedule_types_id,enrollments_status,total,order_all_lunches,summer_pickup_locations_id,registration_fee,discount) 
			values ('" . (int)$customer_id . "', '" . tep_db_input($classes_id) . "', '" . tep_db_input($students_id) . "',  '" . tep_db_input($tuition) . "','" . tep_db_input($lunchTotal) . "','" . tep_db_input($material_fee) . "','" . date('Ymd') . "', '" . tep_db_input($mds) . "', '" . tep_db_input($schedule_types_id) . "','Processing', '" . tep_db_input($total) . "', '" . tep_db_input($order_all_lunches) . "', '" . tep_db_input($summer_pickup_locations_id). "', '". tep_db_input($registration_fee)  . "', '". tep_db_input($discount)  . "')");


		

 return $enrollments_id = tep_db_insert_id();

    }

	

	 function delete_schedule($enrollment_id) {

	  $tuition=get_tuition($classes_id);

            if (tep_session_is_registered('customer_id')) tep_db_query("delete from enrollments where enrollment_id =" . (int)$enrollment_id . "'");

    }

	function get_tuition($classes_id){

		  $check_query = tep_db_query("select tuition from classes where classes_id = '" . $classes_id . "'");

    	 $check = tep_db_fetch_array($check_query);

		 return $check['tuition'];

		

		}

	function get_schedules_types_id($classes_id){

		  $check_query = tep_db_query("select schedules_types_id from classes where classes_id = '" . $classes_id . "'");

    	 $check = tep_db_fetch_array($check_query);

		 return $check['schedules_types_id'];

		

		}

 function add_enrollment_schedule($enrollments_id, $meeting_date,$t) {

 // $meeting_date=strtotime('m-d-Y',$meeting_date);

            if (tep_session_is_registered('customer_id')) tep_db_query("insert into enrollments_schedules (enrollments_id, schedules_date,daily_tuition) values ( '" . tep_db_input($enrollments_id) . "', '" . $meeting_date .   "', '".$t ."')");

			

    }

	function getDaysInRange($sd, $ed, $d) {

		$dates = array(); 

		$ts = strtotime($sd);

		 $te = strtotime($ed);

				while($ts <= $te) { 

						 if($d==1){

						$day = date('D', $ts = strtotime('Monday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==2){

						$day = date('D', $ts = strtotime('tuesday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==3){

						$day = date('D', $ts = strtotime('wednesday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==4){

						$day = date('D', $ts = strtotime('thursday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==5){

						$day = date('D', $ts = strtotime('friday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==6){

						$day = date('D', $ts = strtotime('saturday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

						}

						if($d==7){

						$day = date('D', $ts = strtotime('sunday', $ts));

						if ($ts<=$te)

						$dates[] = $ts;

				}

				$ts = strtotime('tomorrow', $ts);

				}

		return $dates;

}

function getDay($meeting_days){



$mds="";

 foreach ($meeting_days as $d){

		//echo $d;

		switch($d){

		case 1:

		$md='M';

		break;

		case 2:

		$md='T';

		break;

		case 3:

		$md='W';

		break;

		case 4:

		$md='TH';

		break;

		case 5:

		$md='F';

		break;

		case 6:

		$md='Sat';

		break;

		case 7:

		$md='Sun';

		break;

		}

		$mds=($mds==""?$md:($mds.','.$md));

	//$mds =$mds.' '.$md.' ';	

		

 }

 return $mds; 

}



	
  // Returns an array with categories

// Tables: caegories

function tep_get_categories( ){

	  $day_schools_array = array();

      $day_schools = tep_db_query("select classes_categories_id, classes_categories from classes_categories");

      while ($day_schools_values = tep_db_fetch_array($day_schools)) {

        $day_schools_array[] = array('classes_categories_id' => $day_schools_values['classes_categories_id'],

                                   'classes_categories' => $day_schools_values['classes_categories']);

      }



    return $day_schools_array;



}

  // Returns announcements

// Tables: announcements

function tep_get_announcements( ){

	 

      $info = tep_db_fetch_array(tep_db_query("select announcements from announcements where announcements_id=1"));

    return $info['announcements'];



}



  // Return a product's name

// TABLES: products

  function tep_get_afterschool_programs() {

	$today= date('Y-m-d');

			  $product_query = tep_db_query("SELECT classes_name, classes_id FROM classes where classes_categories_id=1 and classes_end_date>='$today'  ");

    

  while (  $product = tep_db_fetch_array($product_query)) {

        $day_schools_products_array[] = array('classes_id' => $product['classes_id'],

											'classes_name' => $product['classes_name']);

      }

    return $day_schools_products_array;

  

  }

   //check if a date is vacation date

    function check_vacation_date($d){

	 $row = tep_db_num_rows (tep_db_query("SELECT * FROM vacation_dates WHERE vacation_dates='".$d."'"));

	  if($row>0)

	  return 1;

	  else

	  return 0;

	  }

  //check if a date is full date

    function check_full_date($d){

	 $row = tep_db_num_rows (tep_db_query("SELECT * FROM full_dates WHERE full_dates='".$d."'"));

	  if($row>0)

	  return 1;

	  else

	  return 0;

	  }

	  //check if a date is full date by school

    function check_school_full_date($d,$day_schools_id){

	 $row = tep_db_num_rows (tep_db_query("SELECT * FROM school_full_dates WHERE school_full_dates='".$d."' and  day_schools_id='".$day_schools_id."'"));

	  if($row>0)

	  return 1;

	  else

	  return 0;

	  }	  

	  //check if a date is short date

    function check_short_date($day_schools_id,$d){

	 $info = tep_db_fetch_array (tep_db_query("SELECT schools_short_day  FROM day_schools WHERE short_day_charge ='Y' and  day_schools_id='".$day_schools_id."'"));

	 $day=date('l',strtotime($d));

	 //if (date('D',strtotime('2012-08-26')) =='Sun')

	 if ($day==$info['schools_short_day'])

	 return 1;

	 else

	 return 0;

	  }  

	  //daily_tuition

    function tep_get_daily_tuition($daily_tuition_name){

	 $info = tep_db_fetch_array (tep_db_query("SELECT daily_tuition FROM daily_tuition WHERE daily_tuition_name ='".$daily_tuition_name ."'"));

	  return $info['daily_tuition'];

	  }

	    //daily_school_tuition

    function tep_get_daily_school_tuition($day_schools_id, $d){

	 $info = tep_db_fetch_array (tep_db_query("SELECT daily_tuition FROM daily_school_tuition WHERE day_schools_id='".$day_schools_id."' and date='".$d."'"));

	  return $info['daily_tuition'];

	  }


	//check registration fee paid

	function check_registration_fee_paid($customers_id){

		$flag=0;

		$query=tep_db_query("SELECT registration_fee_paid FROM students, families,customers WHERE  families.families_id=customers.families_id and families.families_id=students.families_id and students.families_id='".$families_id ."'");

		while($info= tep_db_fetch_array ($query))

		if($info['registration_fee_paid']=='N')

		$flag=1;

		

		if($flag==1)

		return 'No';

		else

		return 'Yes';

		}

		

		//check registration fee paid

	function check_student_register_status($students_id){		

		$query=tep_db_query("SELECT register_status FROM students where students_id='".$students_id ."'");

		$info= tep_db_fetch_array ($query);

		 $flag=$info['register_status'];	
		
		return $flag;

		}

			//check registration fee paid

	function check_student_status($students_id){

		"SELECT students_status FROM students where students_id='".$students_id ."'";

		$query=tep_db_query("SELECT students_status FROM students where students_id='".$students_id ."'");

		$info= tep_db_fetch_array ($query);

		 $flag=$info['students_status'];	

		
		return $flag;

		}
	


	//check material fee paid

	function check_material_fee_paid($students_id, $school_year, $program_types){

		

		}

	  //get customer first name

    function tep_get_customers_first_name($students_id){
		
	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_firstname FROM `students`, customers WHERE students.families_id=customers.families_id and students_id='".$students_id ."'"));

	  return $info['customers_firstname'];

	  }

  //get customer email

    function tep_get_customers_email($students_id){

	 $info = tep_db_fetch_array (tep_db_query("SELECT customers_email_address FROM `students`, customers WHERE students.families_id=customers.families_id and students_id='".$students_id ."'"));

	  return $info['customers_email_address'];

	  }

	//get primary secondary contact

	 function tep_get_primary_contact($families_id,$type){

		  $array = array();

      $query = tep_db_query("select* from contacts where contact_type='".$type."' and families_id='".$families_id."'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('families_id' => $info['families_id'],

						'contacts_work_phone' => $info['contacts_work_phone'],

						'relationship' => $info['relationship'],

						'contacts_cell_phone' => $info['contacts_cell_phone'],

						'contacts_email' => $info['contacts_email'],

						'contacts_last_name' => $info['contacts_last_name'],

                        'contacts_first_name' => $info['contacts_first_name']);

      }



    return $array;



		 }

	

	 //get emergency contacts

	  function tep_get_emergency_contact($families_id,$e){

		  $array = array();

      $query = tep_db_query("select* from contacts where contact_type='".$e."' and families_id='".$families_id."'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('families_id' => $info['families_id'],

						'relationship' => $info['relationship'],

						'contacts_cell_phone' => $info['contacts_cell_phone'],

						'contacts_last_name' => $info['contacts_last_name'],

                        'contacts_first_name' => $info['contacts_first_name']);

      }



    return $array;

		  }

	//get contact

	 function tep_get_contact($families_id){

		  $array = array();

      $query = tep_db_query("select* from contacts where families_id='".$families_id."' order by contact_type");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('families_id' => $info['families_id'],

						'contacts_work_phone' => $info['contacts_work_phone'],

						'relationship' => $info['relationship'],

						'contacts_cell_phone' => $info['contacts_cell_phone'],

						'contacts_email' => $info['contacts_email'],

						'contact_type' => $info['contact_type'],

						'contacts_last_name' => $info['contacts_last_name'],

                        'contacts_first_name' => $info['contacts_first_name']);

      }
    return $array;
		 }

 // Returns an array with full day

// TABLES: full_dates 

  function tep_get_full_dates( ) {
    $array = array();
      $query = tep_db_query("select full_dates_id, full_dates  from full_dates where full_dates >=' ".date('Y-m-d')."'  order by full_dates ");
      while ($values = tep_db_fetch_array($query)) {
        $array[] = array('full_dates_id' => $values['full_dates_id'],
		'full_dates' => $values['full_dates']);
      }
    return $array;
  }

// Returns an array with full days by school

// TABLES: school_full_dates 

  function tep_get_school_full_dates( $day_schools_id) {
    $array = array();
      $query = tep_db_query("select day_schools_id,school_full_dates_id, school_full_dates  from school_full_dates where day_schools_id=".$day_schools_id." and school_full_dates >=' ".date('Y-m-d')."'  order by school_full_dates ");
      while ($values = tep_db_fetch_array($query)) {
        $array[] = array('school_full_dates_id' => $values['school_full_dates_id'],
		'school_full_dates' => $values['school_full_dates']);
      }
    return $array;
  }

 // Returns an array with holiday

// TABLES: vacation_dates  

  function tep_get_vacation_dates( ) {

	  

    $array = array();

      $query = tep_db_query("select vacation_dates_id, vacation_dates   from vacation_dates  where vacation_dates  >=' ".date('Y-m-d')."'  order by vacation_dates ");

      while ($values = tep_db_fetch_array($query)) {

        $array[] = array('vacation_dates_id' => $values['vacation_dates_id'],

		'vacation_dates' => $values['vacation_dates']);

      }



    return $array;

  }

//get contact



	 function tep_get_summer_sports($week,$summer_class_level_id){
	 $array = array();

$query = tep_db_query("select* from summer_sports where summer_week=$week and summer_class_level_id='".$summer_class_level_id  ."' and year='2018' and class_status='Y' order by summer_sport");

      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_sports_id' => $info['summer_sports_id'],
						'summer_sport' => $info['summer_sport'],
						);
      }
    return $array;
		 }

  function tep_get_summer_programs(){
	 $array = array();
          $query = tep_db_query("select* from summer_programs ");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_programs_id' => $info['summer_programs_id'],
						'summer_program' => $info['summer_program'],
						'weekly_cost' => $info['weekly_cost'],
						'weekly_cost_sports' => $info['weekly_cost_sports']
						);
      }
    return $array;
		 }


	  
	function tep_get_summer_art_class_box($summer_class_levels_id,$week){
 
	 $array = array();
 $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE year=2018 and summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."'  group by summer_art_classes_id,summer_art_class");
	// $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."' and summer_art_classes_id<30 group by summer_art_classes_id,summer_art_class");
	$array[] =array('summer_art_classes_id' => 0,
						'summer_art_class' => "Not Attend",
						'checked'=>false 
						);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_art_class' => $info['summer_art_class']
						);
      }
	//  print_r($array);
    return $array;

	  }
	 function tep_get_summer_art_class($summer_class_levels_id,$week){
	 $array = array();
//echo "SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE year=2018 and summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."'  group by summer_art_classes_id,summer_art_class";
 $query = tep_db_query("SELECT summer_art_classes_id,summer_art_class FROM summer_art_classes WHERE year=2018 and summer_class_levels_id ='".$summer_class_levels_id ."' and summer_week='".$week ."' and class_status='Y'  group by summer_art_classes_id,summer_art_class");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_art_class' => $info['summer_art_class'],
						);
      }
    return $array;
		 }

function tep_get_summer_weeks_days($week,$locations_id){
$firstdate=date('Y-m-d', strtotime("first day of january " . date('Y')));
	 $array = array();
        $sql="SELECT * FROM `summer_weeks_days` WHERE summer_week=".$week." and locations_id=".$locations_id." 
	  and `summer_date` >= '".$firstdate."' order by summer_date";
      $query = tep_db_query($sql);
// $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_week=".$week." and status='Y' order by summer_date");
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_day_id' => $info['summer_day_id'],

						'summer_day' => $info['summer_day'],

						'summer_date' => $info['summer_date'],

						'status' => $info['status']

						);

      }

    return $array;

		 }

function tep_get_selected_summer_day($summer_day_id){

	

      $query = tep_db_query("SELECT * FROM `summer_weeks_days` WHERE summer_day_id=".$summer_day_id." order by summer_date");

     $info = tep_db_fetch_array($query) 	;

      $summer_day =$info['summer_day'];

	      return $summer_day;

		 }

		 

function tep_get_first_summer_day_week($week){

	

      $query = tep_db_query("SELECT min(summer_date) as m FROM summer_weeks_days WHERE summer_week=".$week." and status='Y'");

     $info = tep_db_fetch_array($query) 	;

      $summer_date =$info['m'];

	      return $summer_date;

		 } 

		 


function tep_get_summer_date($summer_day_id){

      $query = tep_db_query("SELECT summer_date  FROM summer_weeks_days WHERE summer_day_id=".$summer_day_id);

     $info = tep_db_fetch_array($query) 	;

      $summer_date =$info['summer_date'];

	      return $summer_date;

		 } 			 

function tep_get_day_in_week($summer_day_id){
      $query = tep_db_query("SELECT summer_week FROM `summer_weeks_days` WHERE summer_day_id=".$summer_day_id);
     $info = tep_db_fetch_array($query) 	;
      $summer_week =$info['summer_week'];
	      return $summer_week;
		 }	 

		 
		 
		 function tep_check_full_week_full_day($week,$days_in_week,$summer_sports,$summer_art_classes,$language){
	//check programs
	//if morning, afternoon camp and aftercamp classes are selected => full
	if($summer_sports!=""&&$summer_art_classes!=""&&$language!="")
	 $summer_programs=1;
	//if morning, afternoon camp  are selected or afternoon camp and aftercamp classes are selected=> short
	elseif(($summer_sports!=""&&$summer_art_classes!=""&&$language=="")||($summer_sports==""&&$summer_art_classes!=""&&$language!=""))
	$summer_programs=2;
	//if morning camp  or afternoon camp or aftercamp classes is selected=> half
	elseif($summer_sports!=""||$summer_art_classes!=""||$language!="")
     $summer_programs=4;
	 
	 	 if (is_morning_addon($summer_sports)==1 && is_afternoon_addon($summer_art_classes)==1)
	  $summer_programs=1;
  return $summer_programs;
		 }

function tep_get_summer_weekly_lunch($days_in_week,$summer_class_levels_id,$lunch){
	//lunch cost

	if($summer_class_levels_id==1){
	$dailyLunch=4;
	$weeklyLunch=20;
	}
	if($summer_class_levels_id>=2){
	 $dailyLunch=5;
	$weeklyLunch=25;
	}

	if ($days_in_week<5){    
         
	 $lunchCost=$dailyLunch*$days_in_week;

	}
	if ($days_in_week==5){
             
		 $lunchCost=$weeklyLunch;
		
	}


	return $lunchCost;
	
}

//order lunches individually
function tep_get_summer_weekly_lunch_days($summer_class_levels_id,$lunchdays){
	//lunch cost
	//if ($lunchdays!="")
	//$lunch=1;
	if($summer_class_levels_id==1){
	$dailyLunch=4;
	$weeklyLunch=16;
	}
	
	if($summer_class_levels_id>=2){
	$dailyLunch=5;
	$weeklyLunch=25;
	}
	if ($days_in_week<5){    
         
	 $lunchCost=$dailyLunch*$lunchdays;

	}
	if ($days_in_week==5){
             
			 $lunchCost=$weeklyLunch;
		
	}
	return $lunchCost;
	
}

function tep_get_summer_daily_tuition($summer_programs){

	/*if ($summer_sports!=""&&$summer_sports<7){ 
	  $query = tep_db_query("SELECT `daily_cost_sports` FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
	  $info = tep_db_fetch_array($query) 	;
	  $tuition= $info['daily_cost_sports'];
	  }
	  else{

	  $query = tep_db_query("SELECT `daily_cost` FROM `summer_program_tuition` WHERE `summer_programs_id`=".$summer_programs);
     $info = tep_db_fetch_array($query) 	;
	 $tuition= $info['daily_cost'];
*/
		/*}*/
      return  $tuition=50;
	}	

	

//function tep_get_summer_weekly_tuition($summer_programs,$summer_sports='',$summer_art_classes=''){
	 
 function tep_get_summer_weekly_tuition($summer_programs){
                        $query = tep_db_query("SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`=".$summer_programs);
			$info = tep_db_fetch_array($query) 	;
			 $tuition=$info['weekly_cost']; 


		/*   if (($summer_programs==1)||($summer_programs==2)){
			     if ($summer_sports>6){		
			 $query = tep_db_query("SELECT `weekly_cost`,addon_lego_cost  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
			  $info = tep_db_fetch_array($query) 	;
		  $tuition=$info['weekly_cost']+$info['addon_lego_cost'];
			} 
			
			 if (($summer_art_classes!=""&&$summer_art_classes>58)&&($summer_art_classes!=""&&$summer_art_classes<68)){	
			 	 if ($summer_sports!=""&&$summer_sports<7){
				$query = tep_db_query("SELECT `weekly_cost_sports`,addon_lego_cost  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
				 $info = tep_db_fetch_array($query) 	;
				  $tuition=$info['weekly_cost_sports']+$info['addon_lego_cost'];
				}
			 
			 	if ($summer_sports==7){	 
				$query = tep_db_query("SELECT `weekly_cost`,addon_lego_cost  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
				 $info = tep_db_fetch_array($query) 	;
				  $tuition=$info['weekly_cost']+$info['addon_lego_cost'];
						}
			 }
			if (($summer_art_classes==""||$summer_art_classes<=58)){	
			 	 if ($summer_sports!=""&&$summer_sports<7){	
				$query = tep_db_query("SELECT `weekly_cost_sports`  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
				 $info = tep_db_fetch_array($query) 	;
				  $tuition=$info['weekly_cost_sports']; 
				}
			 
			 	if ($summer_sports==7){	
				$query = tep_db_query("SELECT `weekly_cost`  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
				 $info = tep_db_fetch_array($query) 	;
				  $tuition=$info['weekly_cost'];
						}
			
				}
			 
			
		   }
		  
	  	   if (($summer_programs==4)){
		   
		    if ($summer_sports>6){		 
			 $query = tep_db_query("SELECT `weekly_cost`,addon_lego_cost  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
			  $info = tep_db_fetch_array($query) 	;
		   $tuition=$info['weekly_cost']+$info['addon_lego_cost'];
			} 
			 if ($summer_sports>0&&$summer_sports<7){ 
				$query = tep_db_query("SELECT `weekly_cost_sports` FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['weekly_cost_sports'];
				}
			if ($summer_sports==7){	 
				$query = tep_db_query("SELECT `weekly_cost` FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['weekly_cost'];
				} 
			*/	
		  	  
	   if (($summer_programs==5)||($summer_programs==3)){
		   
		   if (($summer_art_classes!=""&&$summer_art_classes>58)&&($summer_art_classes!=""&&$summer_art_classes<68)){			
			 $query = tep_db_query("SELECT `weekly_cost`,addon_lego_cost  FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
			  $info = tep_db_fetch_array($query) 	;
		 $tuition=$info['weekly_cost']+$info['addon_lego_cost'];
			} 
			else{
				$query = tep_db_query("SELECT `weekly_cost` FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['weekly_cost'];
				}
		  // return  $tuition;
		  
	   }
	   if (($summer_programs==6)){
		   $query = tep_db_query("SELECT `weekly_cost` FROM `summer_programs` WHERE `summer_programs_id`=".$summer_programs);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['weekly_cost'];
		  }
		  
    return  $tuition;

	}

function add_summer_enrollment($enrollments_id,$week,$days_in_week,$summer_programs_id,$summer_class_levels_id,$summer_sports_id,$summer_art_classes_id,$summer_language_class,
$summer_enrollments_weekly_total,$lunch,$aftercamp1,$aftercamp2,$aftercamp3)
 {
      global  $customer_id;
 $weekly_tuition=$summer_enrollments_weekly_total-$lunch;
	 if (tep_session_is_registered('customer_id')) 
$summer_noon_classes="Noon".$summer_class_levels_id;
	 tep_db_query("insert into summer_enrollments(enrollments_id,summer_week,days_in_week,summer_programs_id, summer_class_levels_id, summer_sports_id,summer_noon_classes,
	 summer_art_classes_id,summer_language_class,summer_enrollments_weekly_total,lunch,weekly_tuition,aftercamp1,aftercamp2,aftercamp3) 
	 values ('" . (int)$enrollments_id . "', '" . tep_db_input($week) . "', '" . tep_db_input($days_in_week) . "', '" . tep_db_input($summer_programs_id) . "', 
	 '" . tep_db_input($summer_class_levels_id) . "', '" . tep_db_input($summer_sports_id) . "', '" . tep_db_input($summer_noon_classes) . "', 
	 '" . tep_db_input($summer_art_classes_id) . "','" . tep_db_input($summer_language_class) . "',   '" . tep_db_input($summer_enrollments_weekly_total) . "',  
	 '" . tep_db_input($lunch) . "',   '" . tep_db_input($weekly_tuition) . "',   '" . tep_db_input($aftercamp1) . "',   '" . tep_db_input($aftercamp2) . "',   
	 '" . tep_db_input($aftercamp3) . "')");

		

 return $enrollments_id = tep_db_insert_id();

    }	
	

 function add_summer_enrollment_schedule($enrollments_id, $summer_week,$summer_day_id,$summer_class_levels_id) {

 // $meeting_date=strtotime('m-d-Y',$meeting_date);

            if (tep_session_is_registered('customer_id')) 

			tep_db_query("insert into summer_enrollments_schedules (enrollments_id, summer_week, summer_day_id,summer_class_levels_id) values ( '" . tep_db_input($enrollments_id) . "', '" . $summer_week .   "', '".$summer_day_id .   "', '".$summer_class_levels_id .   "')");

    } 
function add_summer_enrollment_schedule_lunch_pickup($enrollments_id, $summer_week,$summer_day_id,$summer_class_levels_id,$lunch_ordered,$summer_pickup_locations_id) {

 // $meeting_date=strtotime('m-d-Y',$meeting_date);

            if (tep_session_is_registered('customer_id')) 

			tep_db_query("insert into summer_enrollments_schedules (enrollments_id, summer_week, summer_day_id,summer_class_levels_id,lunch_ordered,summer_pickup_locations_id) values ( '" . tep_db_input($enrollments_id) . "', '" . $summer_week .   "', '".$summer_day_id .   "', '".$summer_class_levels_id . "', '".$lunch_ordered .   "', '".$summer_pickup_locations_id .  "')");
    } 

 
//get summer lego programs

	 function tep_get_summer_lego_programs(){

		  $array = array();

      $query = tep_db_query("select* from summer_lego_programs, summer_weeks where summer_lego_programs.summer_week =summer_weeks.summer_week ");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_lego_programs_id' => $info['summer_lego_programs_id'],

						'summer_lego_program' => $info['summer_lego_program'],

						'age' => $info['age'],

						'summer_week' => $info['summer_week'],

						'time' => $info['time'],

						'tuition' => $info['tuition'],

						'summer_week_description' => $info['summer_week_description'],

                        'addon_tuition' => $info['addon_tuition']);

      }



    return $array;



		 }



function add_summer_lego_enrollment($enrollments_id,$summer_lego_programs_id,$summer_week,$students_id,$addon_lego,$summer_lego_tuition) {

      global  $customer_id;

	 if (tep_session_is_registered('customer_id')) 

	 tep_db_query("insert into summer_lego_enrollments(enrollments_id,customers_id, summer_lego_programs_id,summer_week,students_id, addon_lego,summer_lego_tuition) values ('" . (int)$enrollments_id . "','" . (int)$customer_id . "', '" . tep_db_input($summer_lego_programs_id) . "', '" . tep_db_input($summer_week). "', '" . tep_db_input($students_id) . "',  '" . tep_db_input($addon_lego) . "',  '" . tep_db_input($summer_lego_tuition). "')");

		

 return $enrollments_id = tep_db_insert_id();

    }	

	



 //daily_enrollment_count

    function tep_get_daily_summer_enrollment_count($d,$summer_class_levels_id){

	 $info = tep_db_fetch_array (tep_db_query("SELECT count(enrollments_id)as e FROM summer_enrollments_schedules  WHERE summer_day_id   ='".$d ."'"));

	  return $info['e'];

	  }

	  

	//check check_availability($date)

	function check_summer_availability($classes_id,$date,$summer_class_levels_id){

		$info = tep_db_fetch_array (tep_db_query("SELECT max_capacity,min_capacity  FROM classes WHERE classes_id  ='".$classes_id ."'"));

		 $cap=$info['max_capacity'];

		$min=$info['min_capacity'];

		 $e=tep_get_daily_summer_enrollment_count($date,$summer_class_levels_id);

		if ($e<=$cap)

		{

			if($e>=$min)

		 return "waiting";

		 else

		 return 1;

			}

		else

		 return 0;

		}

		




 function tep_get_summer_enrollment($enrollments_id,$week=''){
	 $array = array();
	 if($week==""){
		 $sql="select * from summer_enrollments, summer_class_levels 
	  where summer_enrollments.summer_class_levels_id=summer_class_levels.summer_class_level_id 
and enrollments_id=".$enrollments_id;
	 }else{
		$sql="select * from summer_enrollments, summer_class_levels 
	  where summer_enrollments.summer_class_levels_id=summer_class_levels.summer_class_level_id 
and enrollments_id=".$enrollments_id." and summer_week=".$week;
	 }
	
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_programs_id' => $info['summer_programs_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
						'summer_class_level' => $info['summer_class_level'],
						'weekly_tuition' => $info['weekly_tuition'],
						'summer_enrollments_weekly_total' => $info['summer_enrollments_weekly_total'],
						'days_in_week' => $info['days_in_week'],
						'summer_sports_id' => $info['summer_sports_id'],
						'morning_session' => $info['morning_session'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'aftercamp1' => $info['aftercamp1'],
						'aftercamp1_session' => $info['aftercamp1_session'],
						'aftercamp2' => $info['aftercamp2'],
						'aftercamp2_session' => $info['aftercamp2_session'],
						'aftercamp3' => $info['aftercamp3'],
						'aftercamp3_session' => $info['aftercamp3_session'],
						'summer_week' => $info['summer_week'],
						'lunch' => $info['lunch'],
						'weekly_tuition' => $info['weekly_tuition'],
						'summer_afternoon_classes' => $info['summer_art_classes_id'],
						'summer_language_class' => $info['summer_language_class'],
						'morning_session' => $info['morning_session'],	
						'afternoon_session' => $info['afternoon_session'],	
						'summer_morning_classes' => $info['summer_sports_id'],
						'locations_id' => $info['locations_id']
						);
      }
    return $array;
	}

 function tep_get_summer_enrollment_schedule($enrollments_id, $week){
      $query = tep_db_query("select summer_day_id  from summer_enrollments_schedules  where enrollments_id=".$enrollments_id." and summer_week=".$week);
      while ($info = tep_db_fetch_array($query)) {
        $array[] =  $info['summer_day_id'];
      }
    return $array;
	}
	
function tep_get_summer_program($summer_programs_id){
      $query = tep_db_query("SELECT * FROM  summer_programs WHERE summer_programs_id=".$summer_programs_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['summer_program'];
		 }

function update_summer_schedule($enrollments_id,$mds,$tuition){
		 if (tep_session_is_registered('customer_id')) 
			tep_db_query("update enrollments set meeting_days ='" . tep_db_input($meeting_days) . "', tuition='" . $tuition ."' where enrollments_id= '".$enrollments_id .   "'");
	}

 
	
function  update_summer_weekly_enrollment($enrollments_id, $week,$s,$summer_programs_id,$summer_sports_id,$summer_language_class,$summer_enrollments_weekly_total,$lunch_cost){
	 if (tep_session_is_registered('customer_id')) {
		 //if exist, update
			tep_db_query("update summer_enrollments set summer_week ='" . tep_db_input($week) . "', days_in_week='" . $s .   "', summer_programs_id= '".$summer_programs_id .    "', summer_sports_id='".$summer_sports_id .   "', summer_language_class='".$summer_language_class ."', summer_enrollments_weekly_total='".$summer_enrollments_weekly_total ."', lunch='".$lunch_cost ."' where summer_enrollment_schedule_id= '".$summer_enrollment_schedule_id .   "'");
			//insert
			
	 }
	}	

function  update_summer_enrollment_schedule($enrollments_id , $week,$days,$summer_class_levels_id){
	 if (tep_session_is_registered('customer_id')) {
		 tep_db_query("delete from summer_enrollments_schedules  where enrollments_id= '".$enrollments_id . "' and summer_day_id = '".$days .   "'");
		add_summer_enrollment_schedule($enrollments_id, $week,$days,$summer_class_levels_i);
		 
	}
}

function update_tuition_total($enrollments_id){	 
	$query = tep_db_query("SELECT orders_id FROM   orders_enrollments  WHERE  enrollments_id=".$enrollments_id);
     $info = tep_db_fetch_array($query) 	;
	 $orders_id=$info['orders_id'];
	$query = tep_db_query("SELECT sum(tuition) as s FROM `orders_enrollments`, orders, enrollments WHERE enrollments.enrollments_id=orders_enrollments.enrollments_id and orders_enrollments.orders_id=orders.orders_id and orders.orders_id=".$orders_id);
     $info = tep_db_fetch_array($query) 	;
	 $tuition=$info['s'];
	 tep_db_query("update orders set total=".$tuition." where orders_id=".$orders_id);
	}

 	  //check if a date is short date

    function check_minimum_date($day_schools_id,$d){
		
	 $info = tep_db_fetch_array (tep_db_query("SELECT minimum_dates,grade  FROM minimum_dates WHERE minimum_dates='".$d."' and  day_schools_id='".$day_schools_id."'"));

	$day=date('Y-m-d',strtotime($d));
		$mday=date('Y-m-d',strtotime($info['minimum_dates']));
	 //if (date('D',strtotime('2012-08-26')) =='Sun')

	 if ($day==$mday)

	 return 1;

	 else

	 return 0;

	  }


	
function check_material_fee($students_id){
 
	    $query = tep_db_query("SELECT material_fee_paid FROM `students_material_fee` where `students_id`='".$students_id."'");
	 $info = tep_db_fetch_array($query) 	;
	 $fee=$info['material_fee_paid'];
	 if ($info!="")
     return $fee;
	 else
	 return 0;		

	}
	
		function tep_get_pickup_location($summer_pickup_locations_id){
      $query = tep_db_query("SELECT * FROM `summer_pickup_locations` WHERE summer_pickup_locations_id=".$summer_pickup_locations_id);
     $info = tep_db_fetch_array($query) 	;
	      return  $info['summer_pickup_locations'];
		 }
		 
		 function tep_get_summer_enrollments_orders_payments($orders_id){
		
 $array = array();
    
      $query = tep_db_query("SELECT * 
FROM orders_payments
WHERE orders_id =".$orders_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array(
						'orders_id' => $info['orders_id'],

						'payment_amount' => $info['payment_amount'],
						'payment_method' => $info['payment_method'],
						'check_number' => $info['check_number']

						);

      }

    return $array;
	}

	function tep_get_summer_enrollments_orders($enrollments_id){
	 $array = array();
      $query = tep_db_query("select orders.orders_id from enrollments, orders, orders_enrollments 
	  where enrollments.enrollments_id=orders_enrollments.enrollments_id
		and orders_enrollments.orders_id=orders.orders_id
		and enrollment_date >'2019-01-01' and enrollments.enrollments_id=".$enrollments_id);
     $info= tep_db_fetch_array ($query);
		 $orders_id=$info['orders_id'];			
		return $orders_id;
	}
	
	function tep_get_customer_info($customers_id){     
	 global  $customer_id;          
$array = array();  
 if (tep_session_is_registered('customer_id'))     
$query = tep_db_query("SELECT * FROM `customers` WHERE customers_id=".$customers_id);
while ($info = tep_db_fetch_array($query)) {        
$array[] = array(											
'customers_firstname' => $info['customers_firstname'],						
'customers_lastname' => $info['customers_lastname'],						
'customers_email_address' => $info['customers_email_address'],	
'customers_telephone' => $info['customers_telephone'],		
			
'families_id' => $info['families_id']						
);      
}		 
return $array;		 
}


	
	function tep_get_afternoon_room_assingments_by_class_old($summer_art_class,$sessions_id){

	 $array = array();

      $query = tep_db_query("SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_art_class='".$summer_art_class."' and sessions_id='".$sessions_id."'");
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	 function tep_get_morning_room_assingments_by_class_old($summer_sports,$sessions_id){

	 $array = array();

 "SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports='".$summer_sports."' and sessions_id='".$sessions_id."'";
      $query = tep_db_query("SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports='".$summer_sports."' and sessions_id='".$sessions_id."'");

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],

						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}

function tep_get_one_summer_class($summer_classes_id){
	 $array = array();
      $query = tep_db_query("SELECT * FROM  summer_classes WHERE summer_classes_id=".$summer_classes_id);
      while ($info = tep_db_fetch_array($query)) {
			$array[] = array(
			'summer_classes_id' => $info['summer_classes_id'],
			'summer_class_name' => $info['summer_class_name'],
			'summer_week' => $info['summer_week'],
			'class_period' => $info['class_period'],
			'class_description' => $info['class_description'],
			'addon_status' => $info['addon_status'],
			'class_status'=> $info['class_status'],
			'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
			'summer_week_description' => $info['summer_week_description']
			);
	  }
	 //$info = tep_db_fetch_array($query) 	;
	   // return  $info['summer_class_name'];
		return $array;
		 }
		 

function is_morning_addon($summer_sports) {
//echo "SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_sports."'";
	$query = tep_db_query("SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_sports."'");

         $info = tep_db_fetch_array($query) 	;
	
	 if ($info['addon_status']=='Y')
     return 1;	

	}  
function is_afternoon_addon($summer_art_classes){

 
	    $query = tep_db_query("SELECT `addon_status` FROM summer_classes WHERE summer_classes_id='".$summer_art_classes."'");
	 $info = tep_db_fetch_array($query) 	;
	 if ($info['addon_status']=='Y')
     return 1;		

	}	
	
function tep_get_summer_camp_tuition_old($week,$days_in_week,$summer_sports,$summer_art_classes,$language,$summer_class_levels_id,$lunch){
	//lunch cost
	//if ($lunch!="")
	//$lunch=1;
$tuition=0;
/*	if($summer_class_levels_id==1){
	$dailyLunch=4;
	$weeklyLunch=20;
	}
	if($summer_class_levels_id>=2){
	$dailyLunch=5;
	$weeklyLunch=25;
	}
	*/
	//check programs
	//if morning, afternoon camp and aftercamp classes are selected => full
	if($summer_sports!=""&&$summer_art_classes!=""&&$language!="")
	$summer_programs=1;
	//if morning, afternoon camp  are selected or afternoon camp and aftercamp classes are selected=> short
	elseif(($summer_sports!=""&&$summer_art_classes!=""&&$language=="")||($summer_sports==""&&$summer_art_classes!=""&&$language!=""))
	$summer_programs=2;

	//if morning camp  or afternoon camp or aftercamp classes is selected=> half
	elseif($summer_sports!=""||$summer_art_classes!=""||$language!="")
     $summer_programs=4;
 //echo $summer_sports."---".is_morning_addon($summer_sports)."--".$summer_art_classes."---".is_afternoon_addon($summer_art_classes)."*";
	 	 if (is_morning_addon($summer_sports)==1 && is_afternoon_addon($summer_art_classes)==1)
	   $summer_programs=1;

	if ($days_in_week<5){         
         
          $query = tep_db_query("SELECT `daily_cost` FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
          $info = tep_db_fetch_array($query) 	;
	  $daily_tuition = $info['daily_cost'];
	 // $daily_tuition = tep_get_summer_daily_tuition($summer_programs);
	 $lunchCost=$dailyLunch*$days_in_week;
	   $tuition=$daily_tuition*$days_in_week+$lunchCost*$lunch;

/*
if ($week==3 && $days_in_week==4){
      if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
 $tuition= $tuition-20;
}
}*/


if ($days_in_week==4){
      if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
 //$tuition= $tuition-20;
 if($summer_class_levels_id==7)
	 $tuition= 220;
 else
 $tuition= 180;
}
}

	}
		
		
	if ($days_in_week==5){
              //calculate regular
			 echo "SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'";
            $query = tep_db_query("SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
			$info = tep_db_fetch_array($query) 	;
			 $tuition=$info['weekly_cost']; 
			
            //calculate addon
			

         $query = tep_db_query("SELECT `addon_full`,`addon_short`,`addon_half` FROM `summer_classes` WHERE (`addon_full`>0 or `addon_short`>0 or `addon_half`>0) and `summer_classes_id`='".$summer_sports."'");
			$info = tep_db_fetch_array($query) 	;
		 	$morning_addon=$info['addon_full']; 
			 $morning_addon=$info['addon_short']; 
			 $morning_addon=$info['addon_half']; 
	
              $query = tep_db_query("SELECT `addon_full`,`addon_short`,`addon_half` FROM `summer_classes` WHERE (`addon_full`>0 or `addon_short`>0 or `addon_half`>0) and `summer_classes_id`='".$summer_art_classes."'");
			$info = tep_db_fetch_array($query) 	;
			$afternoon_addon=$info['addon_full']; 
			$afternoon_addon=$info['addon_short']; 
			$afternoon_addon=$info['addon_half']; 
		
	
		/*
		if ($summer_programs==1)
               $tuition=$tuition+$morning_addon+$afternoon_addon;
          if ($summer_programs==2||$summer_programs==3)
              $tuition=$tuition+$morning_addon+$afternoon_addon;
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6)
              $tuition=$tuition;
		 */ 
		  
		  	if ($summer_programs==1){ 
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
				//$tuition=550;
			 $tuition=$tuition+$morning_addon+$afternoon_addon; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){
			
			$tuition=$tuition+$morning_addon+$afternoon_addon; 	
			}
			//$tuition=514;
			else{}
		}

             
          if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){
		  $tuition=$tuition+$morning_addon+$afternoon_addon; }
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+$morning_addon+$afternoon_addon; 
			else{}
		  }
 	
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
			  
			  //if(is_morning_addon($summer_sports)==1) echo "111";
			 // if(is_morning_addon($summer_art_classes)==1) echo "2222";
			  $g="";
			  if($summer_art_classes!=""){
				echo  $g=tep_get_summer_art_class_name($summer_art_classes);
				 
			// echo  $g= tep_get_summer_art_class_name($summer_art_classes );
			
			  }
			  if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g=="Rhythmic Gymnastics*")
			  $tuition=$tuition+$morning_addon+$afternoon_addon;
				if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g!="Rhythmic Gymnastics*")
				 $tuition=305;
          }
		  
/*

		if ($summer_programs==1){
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
			 $tuition=$tuition+225; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+225; 	
			else{}
		}
              
          if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1))
				$tuition=$tuition+225; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=$tuition+225; 
			else{}
		  }
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){
			  if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
			$tuition=285;
          }
*/		
		 // $today = date("m-d-y");   
		//if(($today < date( "Y-m-d", strtotime("04-25-16")))&&$summer_programs==1){
	  //	$tuition =$tuition*.95;
		
		// }
		  
		   $tuition=$tuition+$weeklyLunch*$lunch;
	}
	/*if($lunch==20)
	$lunch_day=1;
    $tuition =$tuition +$lunch*$lunch_day;*/
   //check if sibling discount applies, 5%
   //1. check if another kid in the same family exists in enrollments where classes_id=11 or 12
   
   //2. compare two tuition, apply 5% to lower one
   
   //apply 5% early reg  before apr 12 execpt lego only
  
  	
	      return $tuition;
		 }
		  
	  function tep_get_summer_sport($summer_sports_id,$year=0){
		  if($year>0)
      $query = "SELECT * FROM  summer_classes WHERE summer_classes_id=".$summer_sports_id ." and year=".$year;
  else
	   $query ="SELECT * FROM  summer_classes WHERE summer_classes_id=".$summer_sports_id ;

     $info = tep_db_fetch_array(tep_db_query($query))	;
	      return  $info['summer_sport'];
		 }
	  
 function tep_get_summer_lunch_costs($summer_class_level_id,$year){		
//echo "SELECT daily_lunch_amount  FROM lunch_costs  WHERE summer_class_level_id ='".$summer_class_level_id."' and year=".$year;
      $query = tep_db_query("SELECT daily_lunch_amount  FROM lunch_costs  WHERE summer_class_level_id ='".$summer_class_level_id."' and year=".$year);
     $info = tep_db_fetch_array($query) ;
    return $info['daily_lunch_amount'];
	}
	
	
	 function tep_get_summer_enrollments_lunches($enrollments_id,$summer_day_id=0){
	
	if($summer_day_id==0)
	$sql="SELECT * FROM summer_enrollments_lunches WHERE enrollments_id=".$enrollments_id ;
else 
	$sql="SELECT * FROM summer_enrollments_lunches WHERE enrollments_id=".$enrollments_id." and summer_day_id= ". $summer_day_id;
//echo $sql;	
	$array = array();
	 $query = tep_db_query($sql);
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_class_level_id' => $info['summer_class_level_id'],
						'summer_day_id' => $info['summer_day_id'],
						'lunch_notes' => $info['lunch_notes'],
						'year' => $info['year'],
						'lunch_amount' => $info['lunch_amount']
						);
      }
    return $array;
		 }

	
	 function tep_get_summer_enrollments_schedules($enrollments_id){
	 $array = array();
	 $query = tep_db_query("SELECT * FROM summer_enrollments_schedules WHERE enrollments_id=".$enrollments_id );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_week' => $info['summer_week'],
						'summer_day_id' => $info['summer_day_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
						'lunch_ordered' => $info['lunch_ordered'],
						'summer_pickup_locations_id' => $info['summer_pickup_locations_id']
						);
      }
    return $array;
		 }
		 
		 
		 function tep_get_summer_schedule_by_student($students_id,$locations_id=0){
	 $array = array();
	 $firstdate=date('Y-m-d', strtotime("first day of january " . date('Y')));
//echo "select * from enrollments as en, students as stu where en.students_id=stu.students_id and enrollment_date >'".$firstdate."' and `enrollments_status`!='Canceled'  and en.students_id=".$students_id." and en.locations_id=".$locations_id."  order by enrollments_id desc";	
	if ($locations_id==0){ 
      $query = tep_db_query("select * from enrollments as en, students as stu where en.students_id=stu.students_id and enrollment_date >'".$firstdate."' and `enrollments_status`!='Canceled'  and en.students_id=".$students_id." order by enrollments_id desc");
	 }
		else {
	   $query = tep_db_query("select * from enrollments as en, students as stu where en.students_id=stu.students_id and enrollment_date >'".$firstdate."' and `enrollments_status`!='Canceled'  and en.students_id=".$students_id." and en.locations_id=".$locations_id."  order by enrollments_id desc");
		}
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('tuition' => $info['tuition'],
						'enrollment_date' => $info['enrollment_date'],
						'classes_id' => $info['classes_id'],						
						'students_id' => $info['students_id'],
						'enrollments_status' => $info['enrollments_status'],
						'meeting_days' => $info['meeting_days'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'disabilities' => $info['disabilities'],
						'allergies' => $info['allergies'],
						'medications' => $info['medications'],
						'tuition_paid' => $info['tuition_paid'],
						'enrollments_id'=> $info['enrollments_id'],
                       'total' => $info['total'], 	
						'lunch_total' => $info['lunch_total'],
						'material_fee' => $info['material_fee'],
						'tuition_paid' => $info['tuition_paid'],
						'locations_id' => $info['locations_id']
						);
      }
    return $array;
	}
	 function tep_get_locations($locations_id=0){
	 $array = array();
	 if($locations_id==0){
		 $sql="SELECT * FROM locations";		 
	 }
	 else{
		 $sql="SELECT * FROM locations where locations_id=".$locations_id;
	 }
	
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('locations_id' => $info['locations_id'],
						'locations_name'=> $info['locations_name'],
						'locations_street_address'=> $info['locations_street_address'],
						'locations_city'=> $info['locations_city'],
						'locations_state'=> $info['locations_state'],
						'locations_zipcode'=> $info['locations_zipcode'],
						'locations_phone'=> $info['locations_phone'],
						'map_link'=> $info['map_link'],
						'area'=> $info['area']
						);
      }
    return $array;
		 }
 //get contact
	 function tep_get_authorizaedpickup($families_id){
		  $array = array();
	//	echo "select* from contacts where families_id='".$families_id."' and contact_type like '%AuthorizedPickup%' order by contact_type";
      $query = tep_db_query("select* from contacts where families_id='".$families_id."' and contact_type like '%AuthorizedPickup%' order by contact_type");
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('families_id' => $info['families_id'],
						'contacts_work_phone' => $info['contacts_work_phone'],
						'relationship' => $info['relationship'],
						'contacts_cell_phone' => $info['contacts_cell_phone'],
						'contacts_email' => $info['contacts_email'],
						'contact_type' => $info['contact_type'],
						'contacts_last_name' => $info['contacts_last_name'],
                        'contacts_first_name' => $info['contacts_first_name']);
      }
    return $array;
		 }
	
//update on 2/3/2019, need to sync with prod

function get_current_year_customers_enrollments($customer_id,$year=''){

	//$year=date('Y');

$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));


  $sql="SELECT enrollments.enrollments_id,  enrollments_status,enrollments.tuition, tuition_paid, meeting_days, students_first_name, 
students_last_name,  orders_status, orders.total,enrollments.total as etotal, enrollments.locations_id

FROM enrollments, customers, students, families, orders,  orders_enrollments

WHERE enrollments.students_id = students.students_id 

AND enrollments.customers_id = customers.customers_id 

AND families.families_id = students.families_id 

AND customers.customers_id=orders.customers_id 

AND orders_enrollments.enrollments_id=enrollments.enrollments_id

AND orders.orders_id=orders_enrollments.orders_id
and enrollments_status='Accepted'

and (enrollment_date>='".$start_date."' and enrollment_date<='".$end_date."')

AND (orders_status='Card Payment Completed' or orders_status='Check Received') 

AND orders.date_purchased <='".$end_date."'
AND orders.date_purchased >='".$start_date."'

AND enrollments.customers_id = '" . $customer_id . "' 

group by enrollments.enrollments_id,  enrollments_status,enrollments.tuition, tuition_paid, meeting_days, students_first_name, 
students_last_name,  orders_status, orders.total,enrollments.total, enrollments.locations_id";

	$enrollment_query = tep_db_query($sql);

   $row= tep_db_num_rows($enrollment_query);     

    



while ($enrollment_info = tep_db_fetch_array($enrollment_query)) {

        $enrollment_array[] = array( 'enrollments_id'=> $enrollment_info['enrollments_id'],

										'enrollments_status' => $enrollment_info['enrollments_status'],

										'tuition' => $enrollment_info['tuition'],
										'total' => $enrollment_info['total'],
										'etotal' => $enrollment_info['etotal'],
										'locations_id' => $enrollment_info['locations_id'],

										'meeting_days' => $enrollment_info['meeting_days'],

										'day_schools_name' => $enrollment_info['day_schools_name'],

										'students_first_name' => $enrollment_info['students_first_name'],
										'tuition_paid'=>$enrollment_info['tuition_paid'],
										'students_last_name' => $enrollment_info['students_last_name'],
										);
      }
return $enrollment_array;	

	}



function tep_get_summer_week_description($week,$year){

      $query = tep_db_query("SELECT summer_week_description FROM summer_weeks WHERE summer_week=".$week." and summer_year=".$year);

     $info = tep_db_fetch_array($query) 	;

      $summer_week_description =$info['summer_week_description'];

	      return $summer_week_description;

		 } 		
		 
function tep_get_summer_family_enrollments_total($customers_id, $year){	   
$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
  
		
		 $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
enrollments.total, enrollments.material_fee, 	 students_first_name, students_last_name, sibling_discount
FROM enrollments,   customers, families, students
WHERE 
 enrollments.customers_id = customers.customers_id
AND enrollments.students_id = students.students_id
AND families.families_id = customers.families_id
AND families.families_id = students.families_id 
and (enrollments_status='Accepted')
and enrollment_date  <='".$end_date."'
AND enrollment_date >='".$start_date."'
and enrollments.customers_id=".$customers_id;

		$result=tep_db_query($sql);	
$enrollment_total=0;		
					while($row=tep_db_fetch_array($result))
			{$enrollment_total+=$row['total'];}
		return $enrollment_total;
	}
function tep_get_summer_family_enrollments_total_in_cart($customers_id, $year){	   
$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
  
		
		 $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
enrollments.total, enrollments.material_fee, 	 students_first_name, students_last_name, sibling_discount
FROM enrollments,   customers, families, students
WHERE 
 enrollments.customers_id = customers.customers_id
AND enrollments.students_id = students.students_id
AND families.families_id = customers.families_id
AND families.families_id = students.families_id 
and (enrollments_status='Accepted'||enrollments_status='Processing'||enrollments_status='Cart Processing')
and enrollment_date  <='".$end_date."'
AND enrollment_date >='".$start_date."'
and enrollments.customers_id=".$customers_id;

		$result=tep_db_query($sql);	
$enrollment_total=0;		
					while($row=tep_db_fetch_array($result))
			{$enrollment_total+=$row['total'];}
		return $enrollment_total;
	}

	function tep_get_summer_family_payments_total($customers_id,$year){	
	$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	$sql1="SELECT payment_date, payment_amount, orders_payments.payment_method, transaction_id, orders_payments.check_number,orders_payments.orders_id
FROM orders, customers, orders_payments
WHERE orders.customers_id = customers.customers_id
AND orders_payments.orders_id = orders.orders_id

and payment_date  <='".$end_date."'
AND payment_date >='".$start_date."'
AND (
orders_status = 'Card Payment Completed'
OR orders_status = 'Check Received'
)
AND orders.customers_id =".$customers_id."
order by payment_date
";
		$result1=tep_db_query($sql1);
		
$payment_total=0;		
					while($row1=tep_db_fetch_array($result1))
			{  
			$payment_total+= $row1['payment_amount'];}
			
			return $payment_total;
	}


	function tep_get_summer_family_refunds_total($customers_id,$year){	
		$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	
		$sql2="SELECT orders_refunds_id,refund_amount
FROM orders,customers, orders_refunds
WHERE orders.customers_id = customers.customers_id
AND orders.orders_id = orders_refunds.orders_id
and `refund_date` >'".$start_date."'
and refund_date  <='".$end_date."'
AND orders.customers_id =".$customers_id." 
group by orders_refunds_id,refund_amount";
	$result2=tep_db_query($sql2);	
$refund_total=0;		
					while($row2=tep_db_fetch_array($result2))
			{
			$refund_total+=$row2['refund_amount'];}
			
			return $refund_total;
	}
	
	////
	
	
	function tep_get_summer_family_cancellation_fee_total($customers_id,$year){	
	$start_date=$year.'-01-01';
	$start_date=date('Y-m-d',strtotime($start_date));
	$end_date=$year.'-12-31';
	$end_date=date('Y-m-d',strtotime($end_date));
	
	$sql2="SELECT cancellation_fee
FROM enrollments
WHERE 
 `enrollment_date` >'".$start_date."'
and enrollment_date  <='".$end_date."'
AND customers_id =".$customers_id;
	$result2=tep_db_query($sql2);	
$cancellation_fee_total=0;		
					while($row2=tep_db_fetch_array($result2))
			{
			$cancellation_fee_total+=$row2['cancellation_fee'];}
	
	return $cancellation_fee_total;
	}

// Return a student's name

// TABLES: students

  function tep_get_student($students_id) {
	  global $customer_id;
	
    if ( tep_session_is_registered('customer_id')){

	$student_array= array();

  /*  $student_query = tep_db_query("select * from  students, families, customers 
where students.families_id=families.families_id
and customers.families_id=families.families_id
and students_id = '" . (int)$students_id ."'
and customers.customers_id='" . (int)$customer_id ."'");*/
$student_query = tep_db_query("select * from  students
where students_id = " . (int)$students_id );

if( $student_query !="") {
 while ($student_values = tep_db_fetch_array($student_query)) {

		 $student_array[] = array(
		 'day_schools_id' => $student_values['day_schools_id'],
		 'grade' => $student_values['grade'],
		'families_id' => $student_values['families_id'],
		 'students_first_name' => $student_values['students_first_name'],		
		'students_last_name' => $student_values['students_last_name'],
		'gender' => $student_values['gender'],
		'students_status' => $student_values['students_status'],
		'disabilities' => $student_values['disabilities'],
		'allergies' => $student_values['allergies'],
		'medications' => $student_values['medications'],
		'doctor' => $student_values['doctor'],
		'doctor_phone' => $student_values['doctor_phone'],
		'doctor_address' => $student_values['doctor_address'],
		'registration_fee_paid' => $student_values['registration_fee_paid'],
		'register_status' => $student_values['register_status'],
		'birthday' => $student_values['birthday'],
		'agreement_link' => $student_values['agreement_link'],
		'registration_status' => $student_values['registration_status'],
		'media_release' => $student_values['media_release'],
		
		) ;

			 }

    return $student_array;
}
else {
	return 0;
	
}
	}


  }
  
  

	
	
	function tep_get_summer_week ($locations_id,$year){
		$array= array();
		 $sql="select * from  summer_weeks
where locations_id = '" . (int)$locations_id ."' 
and summer_year = '" . (int)$year ."' ";

    $query = tep_db_query($sql);
if( $query !="") {
 while ($values = tep_db_fetch_array($query)) {

		 $array[] = array(
		 'summer_week' => $values['summer_week'],
		'summer_week_id' => $values['summer_week_id'],
		'summer_week_description' => $values['summer_week_description'],
		'camp_days' => $values['camp_days'],
		'summer_year' => $values['summer_year']
		) ;

			 }

    return $array;
	}
	}
	
	function tep_get_summer_schedule($enrollments_id){

	 $array = array();


      $query = tep_db_query("select * from enrollments as en, students as stu where en.students_id=stu.students_id and  en.enrollments_id=".$enrollments_id);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('tuition' => $info['tuition'],
						'enrollment_date' => $info['enrollment_date'],
						'classes_id' => $info['classes_id'],						
						'students_id' => $info['students_id'],
						'enrollments_status' => $info['enrollments_status'],
						'meeting_days' => $info['meeting_days'],
						'students_last_name' => $info['students_last_name'],
						'students_first_name' => $info['students_first_name'],
						'disabilities' => $info['disabilities'],
						'allergies' => $info['allergies'],
						'medications' => $info['medications'],
						'total' => $info['total'], 	
						'lunch_total' => $info['lunch_total'],
						'material_fee' => $info['material_fee'],
						'material_fee_waived' => $info['material_fee_waived'],
						'tuition_paid' => $info['tuition_paid'],
                         'order_all_lunches' => $info['order_all_lunches'],
						'discount' => $info['discount'], 
						'promotion_discount' => $info['promotion_discount'], 
						'other_discount' => $info['other_discount'], 
						'early_bird_discount' => $info['early_bird_discount'], 
					    'sibling_discount' => $info['sibling_discount'], 
						'registration_fee' => $info['registration_fee'],
						'registration_fee_waived' => $info['registration_fee_waived'],						
						'summer_pickup_locations_id' => $info['summer_pickup_locations_id'],							   
						'locations_id' => $info['locations_id'],
						'year' => $info['year'],
						'customers_id'=> $info['customers_id']
						);
      }
    return $array;
	}
	

	
		 function tep_get_promotion_codes($locations_id=0,$year=0,$promotion_codes=''){
		    global  $customer_id;	 
       
		  $array = array();
		  $sql="select * from promotion_codes";
		   if($locations_id>0 &&$year>0&&$promotion_codes!="")
		  $sql="select * from promotion_codes where locations_id='".$locations_id ."' and year='".$year ."' and promotion_codes='".$promotion_codes."'";
		  elseif($locations_id>0 &&$year>0)
		  $sql="select * from promotion_codes where locations_id='".$locations_id ."' and year='".$year ."'";
		  elseif($locations_id>0 )
		  $sql="select * from promotion_codes where locations_id='".$locations_id ."'";
		  elseif($year>0)
		  $sql="select * from promotion_codes where year='".$year ."'";	
			elseif($promotion_codes!="")
		  $sql="select * from promotion_codes where promotion_codes='".$promotion_codes ."'";			  
		
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array(
		'promotion_codes_id' => $info['promotion_codes_id'],
		'promotion_amount' => $info['promotion_amount'],
		'promotion_codes' => $info['promotion_codes'],
		'promotion_rate' => $info['promotion_rate'],
		'promotion_start_date' => $info['promotion_start_date'],
		'promotion_end_date' => $info['promotion_end_date'],
		'minimum_amount' => $info['minimum_amount'],
		'minimum_weeks' => $info['minimum_weeks'],
		'year' => $info['year'],
		'locations_id' => $info['locations_id'],
		'notes' => $info['notes']
		);		
      }
    return $array;
			
		 }
	  function tep_add_promotion_logs($orders_id,$promotion_code,$applied_amount,$status='',$notes='') 
  {
      global  $customer_id;	 
	  //calculate versioning
	  $version=0;
	  $status="";
	  //$notes="";         
				tep_db_query("insert into promotion_logs(orders_id, promotion_code,applied_amount,applied_datetime,status,version,notes) 
				values ('" . (int)$orders_id . "', 
				'" . tep_db_input($promotion_code) . "', 
				'" . $applied_amount. "',  
				'" . date("Y-m-d H:i:s") . "',  
				'" . $status. "',  
				'" . $version. "',  
				'" . $notes. "')");
		return $promotion_logs_id = tep_db_insert_id();		

    }
  function tep_add_promotion_logs_enrollments($enrollments_id,$promotion_code,$applied_amount,$status='',$notes='') 
  {
      global  $customer_id;	 
	  //calculate versioning
	  $version=0;
	  $status="";
	  //$notes="";         
				tep_db_query("insert into promotion_logs(enrollments_id, promotion_code,applied_amount,applied_datetime,status,version,notes) 
				values ('" . (int)$enrollments_id . "', 
				'" . tep_db_input($promotion_code) . "', 
				'" . $applied_amount. "',  
				'" . date("Y-m-d H:i:s") . "',  
				'" . $status. "',  
				'" . $version. "',  
				'" . $notes. "')");
		return $promotion_logs_id = tep_db_insert_id();		

    }
	
	function tep_add_customers_cart($customers_id,$orders_id,$family_tuition_total,$family_registration_fee,$family_material_fee,$family_discount_total,
	$family_early_bird_discount,$family_sibling_discount,$family_material_fee_waived,$family_registration_fee_waived,$family_promotion_discount,$family_paid_amount,$family_lunch_total,$balance,$family_other_discount=0,$status='',$notes='') 
  {
      global  $customer_id;	 
	  //calculate versioning	
	  $status="";     
    $sql_data_array = array(
	'customers_id'=>$customers_id , 
	'orders_id'=>$orders_id , 
	'created_date'=>date("Y-m-d H:i:s") , 
	'family_tuition_total'=>$family_tuition_total , 
	'family_registration_fee'=>$family_registration_fee , 
	'family_material_fee'=>$family_material_fee , 
	'family_discount_total'=>$family_discount_total , 
	'family_early_bird_discount'=>$family_early_bird_discount , 
	'family_sibling_discount'=>$family_sibling_discount , 
	'family_material_fee_waived'=>$family_material_fee_waived , 
	'family_registration_fee_waived'=>$family_registration_fee_waived , 
	'family_promotion_discount'=>$family_promotion_discount,
	'family_other_discount'=>$family_other_discount,
	'family_paid_amount'=>$family_paid_amount,
	'family_lunch_total'=>$family_lunch_total,
	'balance'=>$balance,
	'status'=>$status , 
	'notes'=>$notes 
     );
		 tep_db_perform('customers_cart', $sql_data_array);		
 $customers_cart_id = tep_db_insert_id();

 return $customers_cart_id ;
    }
	
	function tep_add_customers_cart_enrollment($customers_cart_id,$enrollments_id) 
  {
      global  $customer_id;	 
	  //calculate versioning	
	    $sql_data_array1 = array(
	'customers_cart_id'=>$customers_cart_id , 
	'enrollments_id'=>$enrollments_id , 
	'last_modified'=>date("Y-m-d H:i:s")
	//'notes'=>$notes 
     );
		 tep_db_perform('customers_cart_enrollments', $sql_data_array1);	
 $customers_cart_enrollments_id = tep_db_insert_id();

 return $customers_cart_enrollments_id ;
    }
	 function tep_get_customers_cart($customer_id,$current_year_first_day){
		    global  $customer_id;	 
       
		  $array = array();
		  $sql="select * from customers_cart 
		  where customers_id=".$customer_id." and created_date>='".$current_year_first_day."' 
		  order by created_date desc";	  	  
		
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array(
		'customers_cart_id'=>$info['customers_cart_id'] ,
		'customers_id'=>$info['customers_id'] , 
	'orders_id'=>$info['orders_id'] , 
	'created_date'=>date("Y-m-d H:i:s") , 
	'family_tuition_total'=>$info['family_tuition_total'] , 
	'family_registration_fee'=>$info['family_registration_fee'] , 
	'family_material_fee'=>$info['family_material_fee'] , 
	'family_discount_total'=>$info['family_discount_total'] , 
	'family_early_bird_discount'=>$info['family_early_bird_discount'] , 
	'family_sibling_discount'=>$info['family_sibling_discount'] , 
	'family_material_fee_waived'=>$info['family_material_fee_waived'] , 
	'family_registration_fee_waived'=>$info['family_registration_fee_waived'] , 
	'family_promotion_discount'=>$info['family_promotion_discount'],
	'family_paid_amount'=>$info['family_paid_amount'],
	'family_lunch_total'=>$info['family_lunch_total'],
	'balance'=>$info['balance'],
	'status'=>$info['status'] , 
	'notes'=>$info['notes']
		);		
      }
    return $array;
			
		 }
  function tep_format_number($number,$digit=2) {
	      return   number_format($number,$digit, '.', '') ;
  }
//  function tep_add_enrollment($students_id,$mds,$tuition,$total, $material_fee=0, $registration_fee=0,$year,$locations_id) 
 function tep_add_enrollment($students_id,$mds,$tuitionOnly,$total,$lunchtotal,$material_fee, 
		$discount,$registration_fee,$year,$locations_id,$early_bird_discount,
		$sibling_discount,$material_fee_waived,
		$registration_fee_waived,$promotion_discount,$other_discount,$enrollments_status)
  {
      global  $customer_id;
    $sql_data_array = array(
                               'customers_id' => $customer_id,
                              'students_id' => $students_id,
                              'tuition' => $tuitionOnly,
							  'total' => $total,
							  'lunch_total'=>$lunchtotal,
                              'material_fee' => $material_fee,
							  'registration_fee' => $registration_fee, 
							  'discount' =>$discount,
							  'enrollment_date' => date("Y-m-d H:i:s"),
                              'meeting_days' => $mds,
                              'enrollments_status' => $enrollments_status,
							  'early_bird_discount'=>$early_bird_discount,
							  'sibling_discount'=>$sibling_discount,
							  'material_fee_waived'=>$material_fee_waived,
							  'registration_fee_waived'=>$registration_fee_waived,
							  'promotion_discount'=>$promotion_discount,
							  'other_discount'=>$other_discount,
							  'year' => $year,  
							  'locations_id' => $locations_id,
							  'last_modified'	=> date("Y-m-d H:i:s")
							  );
		 tep_db_perform('enrollments', $sql_data_array);	
		

 return $enrollments_id = tep_db_insert_id();

    }
	
 // function tep_check_early_bird_eligibility($enrollment_id,$early_bird_min_weeks){
	  function tep_check_early_bird_eligibility($enrollment_id){
	  $status="N";  
	  $week_count=0;
	
		  $sql="SELECT * FROM `summer_enrollments`, enrollments WHERE enrollments.`enrollments_id`=summer_enrollments.`enrollments_id` and summer_enrollments.`enrollments_id`='" . (int)$enrollment_id . "'";	  	  
		
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
	  if(($info['summer_sports_id']!=""&& $info['summer_art_classes_id']!=""&& $info['summer_language_class']!="")
		  &&(($info['days_in_week']==5&&$info['summer_week']!=3)||($info['days_in_week']==4&&$info['summer_week']==3))
	  )
		   $week_count++;
		   
		   $locations_id=$info['locations_id'];
	  }
	////////// hard code minimal weeks, should change to database configuration later
	
	if($locations_id==1)
		$early_bird_min_weeks=6;
	if($locations_id==2)
		$early_bird_min_weeks=4;
	////////// hard code minimal weeks

	  if ($week_count>=$early_bird_min_weeks)
	  $status="Y"; 
	  return $status;
  }

  function tep_add_refund_requests($orders_id,$refund_requests_amount=0, $refund_requests_status='', $refund_requests_notes='') 
  {
      global  $customer_id;
	  $c_info=tep_get_customer_info($customer_id);
	  $customer_name=$c_info[0]['customers_firstname']." ".$c_info[0]['customers_lastname'];
    $sql_data_array = array(
                              'customers_id' => $customer_id,
                              //'orders_id' => $orders_id,
                              'refund_requests_status' => $refund_requests_status,
							  'refund_requests_amount' => $refund_requests_amount,
							  'refund_requests_date ' => date("Y-m-d H:i:s"),
							  'input_user'=> $customer_name
							  );
		 tep_db_perform('refund_requests', $sql_data_array);	
		

 return $refund_requests_id = tep_db_insert_id();

    }
	
	  function tep_check_enrollment_availability($enrollment_id){	
	  $count=0;
		   $sql="SELECT * FROM `summer_enrollments` WHERE `enrollments_id`='" . (int)$enrollment_id . "'";	
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
		  
		if(  check_class_availability($info['summer_sports_id'])=="N"||check_class_availability($info['summer_art_classes_id'])=="N"){		  	  
		   $count++;
		   }			
			}	
			return $count;
	  }
  	//check check_availability($date)

	function check_class_availability($classes_id){
	
		$info = tep_db_fetch_array (tep_db_query("SELECT *  FROM summer_classes WHERE summer_classes_id  ='".$classes_id ."'"));

		$class_status=$info['class_status'];

		return $class_status;
		}
	 function tep_count_class_enrollment($classes_id,$class_period,$year){	
	  $count=0;
	    if ($class_period=="Morning")
	  $period_name="summer_sports_id";
  if ($class_period=="Afternoon")
	  $period_name="summer_art_classes_id";
  if ($class_period=="Aftercamp1")
	  $period_name="aftercamp1";
  if ($class_period=="Aftercamp2")
	  $period_name="aftercamp2";
  if ($class_period=="Aftercamp3")
	  $period_name="aftercamp3";
	
		   $sql="SELECT * FROM `summer_enrollments`, summer_classes, enrollments
	   WHERE summer_classes.summer_classes_id=summer_enrollments.".$period_name."
	   and enrollments.enrollments_id=summer_enrollments.enrollments_id
	   and summer_classes.year='".$year."'
	   and enrollments.year='".$year."'
	   and (enrollments.enrollments_status='Accepted' or enrollments.enrollments_status='Processing' or enrollments.enrollments_status='Cart Processing')
		and summer_classes.summer_classes_id='" . (int)$classes_id . "'";	
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
		  $count++;					
			}	
			return $count;
	  }
	 

	 function tep_get_summer_class_levels($locations_id,$year){

	 $array = array();
	 $sql="select* from summer_class_levels where summer_class_level!='All' and summer_class_level_id>1";
	  if($locations_id==1)
		$sql="select* from summer_class_levels  where summer_class_level!='All' and summer_class_level_id>1";
	 if($locations_id==2)
		$sql="select* from summer_class_levels  where summer_class_level!='All' and summer_class_level_id<=6";
     // $query = tep_db_query("select* from summer_class_levels where locations_id='".$locations_id."' and year='".$year."' and summer_class_level!='All'");
$query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_class_level_id' => $info['summer_class_level_id'],

						'summer_class_level' => $info['summer_class_level'],

						);
      }

    return $array;
		 }
		 

	  



 function tep_get_summer_art_class_name($summer_art_classes_id,$year=0 ){
  if($year>0)
	 $query="SELECT * FROM summer_classes WHERE summer_classes_id  =".$summer_art_classes_id." and year=".$year ;
	else
			 $query="SELECT * FROM summer_classes WHERE summer_classes_id  =".$summer_art_classes_id ;
		 
		
 $info = tep_db_fetch_array (tep_db_query($query));
	  return $info['summer_class_name'];

	  }
	  
	  
	  function tep_get_summer_camp_tuition($week,$days_in_week,$summer_sports,$summer_art_classes,$language,$summer_class_levels_id,$lunch){

$tuition=0;
$m=0;$a=0;$l=0;
$addon=126;
	//check programs
	if($summer_sports!="")
		$m=1;
	if($summer_art_classes!="")
		 $a=1;
	if($language!="")
		 $l=1;
	 $p=$m+$a+$l;

	if($p==3)
		$summer_programs=1; //extended
	if($p==2)
		$summer_programs=2; //full day
	if($p==1)
		$summer_programs=4; //half day
	 $summer_programs;



	if ($days_in_week==5){
              //calculate regular
/*        
		$query = tep_db_query("SELECT `weekly_cost`  FROM `summer_program_tuition` WHERE `summer_programs_id`='".$summer_programs."' and summer_class_levels_id='".$summer_class_levels_id."'");
			$info = tep_db_fetch_array($query) 	;
			 $tuition=$info['weekly_cost']; 
		*/
			// hardcode tuition cost
			 if($summer_programs==1)
				$tuition=469;
			if($summer_programs==2)
				$tuition=399;
			if($summer_programs==4)
				$tuition=229;
			
            //calculate addon	

			$g="";
			  if($summer_art_classes!=""){
			  $g=tep_get_summer_art_class_name($summer_art_classes);
			  }
		  
		  	if ($summer_programs==1){ 
			if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){				
				
					$tuition=469+$addon+$addon; //469+126+126
			}
			 //$tuition=$tuition+$morning_addon+$afternoon_addon; 
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){
			
			$tuition=469+$addon; //469+126=595
			}		
			else{}
		}
            
          if ($summer_programs==2||$summer_programs==3){
		  if((is_morning_addon($summer_sports)==1&&is_afternoon_addon($summer_art_classes)==1)){
					 
			   $tuition=399+$addon+$addon;//399+126+126
		  }				
			else if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)){				
		
			
			$tuition=399+$addon;//399+126=525
			}			
			else{}
		  } 	
          if ($summer_programs==4||$summer_programs==5||$summer_programs==6){			  
			
				if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1)&&$g!="Rhythmic Gymnastics*")
				
			$tuition=229+$addon;
          }  
 
		   $tuition=$tuition+$weeklyLunch*$lunch;
	}   
		////////////// July 4-day week///////////////////
		if ($week==5){    
				$addon=100;
				   if ($summer_programs==4)	{	
				   $tuition= 190;
				   	if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=190+$addon;
				   }
					if ($summer_programs==2){	
						$tuition= 320;
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=320+$addon;//400
					}
					if ($summer_programs==1){		
						$tuition= 380;	
						if((is_morning_addon($summer_sports)==1||is_afternoon_addon($summer_art_classes)==1))
						$tuition=380+$addon;//460					
					}
				}
	
	      return $tuition;
		 }
	  
	  
  function tep_get_student_forms_log($students_id,$current_year_first_day,$form_type='Behavior Contract') {

	global $customer_id;
    if ( tep_session_is_registered('customer_id')){
	$array= array();
		$sql="SELECT * FROM `student_forms_log` WHERE students_id='" . (int)$students_id ."' and datetime>'".$current_year_first_day."' and form_type='".$form_type."' order by datetime desc";
    $query = tep_db_query($sql);
	 while ($values = tep_db_fetch_array($query)) {
		  $array[] = array(
		  'student_forms_log_id' => $values['student_forms_log_id'],
		  'student_signature' => $values['student_signature'],
		  'parent_signature' => $values['parent_signature'],
		  'notes' => $values['notes'],
		   'datetime' => $values['datetime'],
		   
		  'form_type' => $values['form_type']
		  );
	 }
	  return $array;
	}
	
	}
	 function tep_get_room_assingments($class_period,$summer_classes_id,$sessions_id){

	 $array = array();
	 
	if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){	
		$class_id="summer_aftercamp_id";
	}
	//////////// morning & afternoon not work//////////////// should pull class name instead of id///////// needs update after summer2019
	if($class_period=="Morning"){
		$class_id="summer_sports";
	}
	if($class_period=="Afternoon"){
		$class_id="summer_art_classes";
	}
	
	  $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	 and ".$class_id." ='".$summer_classes_id."' and sessions_id='".$sessions_id."'";
	 


      $query = tep_db_query($sql);
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
		 
	 function tep_get_morning_room_assingments_by_class($summer_sports,$sessions_id,$locations_id,$year,$summer_week){

	 $array = array();
	 $sql="SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and summer_sports='".$summer_sports."' and sessions_id='".$sessions_id
	  ."' and year='".$year
	    ."' and summer_week='".$summer_week."'
		and summer_room_assignments.locations_id='".$locations_id."'
	  order by summer_room_assignments_id desc";


      $query = tep_db_query($sql);

      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],

						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
	function tep_get_afternoon_room_assingments_by_class($summer_art_class,$sessions_id,$locations_id,$year,$summer_week){

	 $array = array();

      $query = tep_db_query("SELECT * FROM summer_room_assignments, employees, rooms
	  WHERE summer_room_assignments.employees_id=employees.employees_id
	  and summer_room_assignments.rooms_id=rooms.rooms_id
	  and year='".$year
	    ."' and summer_week='".$summer_week." '
	  and summer_art_class='".$summer_art_class."' and sessions_id='".$sessions_id."'");
	  
      while ($info = tep_db_fetch_array($query)) {

        $array[] = array('summer_room_assignments_id' => $info['summer_room_assignments_id'],

						'summer_week' => $info['summer_week'],
'summer_art_class' => $info['summer_art_class'],
						'summer_sports' => $info['summer_sports'],
						'summer_language' => $info['summer_language'],
						'summer_art_class' => $info['summer_art_class'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
 						'employees_id' => $info['employees_id'],
						'rooms_id' => $info['rooms_id'],	
						'employees_first_name' => $info['employees_first_name'],
						 'employees_last_name' => $info['employees_last_name'],
						  'employees_full_name'=>$info['employees_first_name']." ".$info['employees_last_name'],
						'rooms_number' => $info['rooms_number'],
						'rooms_id' => $info['rooms_id'],
						'year' => $info['year'],
                        'lunch_total' => $info['lunch_total'],
						'registration_fee' => $info['registration_fee'],
						'material_fee_total' => $info['material_fee_total'],				
						'sessions_id' => $info['sessions_id'],
						'classes_id' => $info['classes_id']
						);
      }

    return $array;

	}
////////////////////keep 2019 functions, remove later 2020////////////////////////

////////////////////new or update functions 2020////////////////////////

 function check_agreement_status($customers_id,$current_year_first_day){
$flag=0;
		
 $sql="SELECT * FROM `action_logs` WHERE `customers_id`='".$customers_id ."' 
and `change_datetime`>'".$current_year_first_day."'
and (page='agreement' or page='Agreement')";
		$query=tep_db_query($sql);

		$info= tep_db_fetch_array ($query);

		 if($info['customers_id']>0)
		$flag=1	;		
		return $flag;

		}
		
		    function tep_get_year_action_logs($customer_id,$year) {
	$current_year_first_day=$year.'-01-01';
	global $customer_id;
    if ( tep_session_is_registered('customer_id')){
	$array= array();
	 $sql="SELECT * FROM `action_logs` WHERE customers_id='" . (int)$customer_id ."' and `change_datetime`>'".$current_year_first_day."'";
    $query = tep_db_query($sql);
	 while ($values = tep_db_fetch_array($query)) {
		  $array[] = array(
		  'logs_id' => $values['logs_id'],
		  'administrators_id' => $values['administrators_id'],
		  'change_datetime' => $values['change_datetime'],
		  'notes' => $values['notes'],
		  'customers_signature' => $values['customers_signature'],
		  'page' => $values['page']
		  );
	 }
	  return $array;
	}
	
	}
	// 2020 added courses table, join with courses_id
	// get morning or afternoon classes. $class_period (Morning or Afternoon)
	 function tep_get_summer_classes($summer_class_level_id,$week,$class_period,$locations_id,$year,$class_status=''){
	 $array = array();  

	 if ($class_status=='Y'){
		 $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and class_status='Y' 
and status='Active'
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
	 ";}
else{
  $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and status='Active'
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
";
}
 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'courses_name' => $info['courses_name'],						
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						//'class_status' => $info['class_status'],						
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
	
	

  function tep_get_enrollment_course_change_request($enrollments_id){
	 $array = array();
	  $current_year_first_day=date('Y-m-d', strtotime('first day of january this year'));
	
		 $sql="SELECT * FROM course_change_request where enrollments_id=".$enrollments_id." and  course_change_request_id>=648 and status !='Canceled' order by course_change_request_id Desc";
	
	 $query = tep_db_query($sql );
	 while ($info = tep_db_fetch_array($query)) {
        $array[] = array(						
						'course_change_request_id'=> $info['course_change_request_id'],
						'students_first_name'=> $info['students_first_name'],
						'students_last_name'=> $info['students_last_name'],
						'course_change_message'=> $info['course_change_message'],
						'customers_id'=> $info['customers_id'],
						'enrollments_id'=> $info['enrollments_id'],						
						'status'=> $info['status'],
						'last_modified'=> $info['last_modified'],
						'last_modified_by'=> $info['last_modified_by'],
						'notes'=> $info['notes']
						);
      }
    return $array;
		 }
	 

	//////////////////////////// 2023 ///////////////////////////////
	 	function tep_get_summer_family_enrollments($customers_id, $year,$status){	   
	 $start_date=$year.'-01-01';
	 $start_date=date('Y-m-d',strtotime($start_date));
	 $end_date=$year.'-12-31';
	  $end_date=date('Y-m-d',strtotime($end_date));
  
		 $array = array();	
		 if ($status=="Accepted"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status='Accepted')
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 if ($status=="Processing"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status ='Processing' or enrollments_status='Cart Processing' )
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }
		 
		 if ($status=="Not Draft"){
		  $sql="SELECT enrollments.enrollments_id,enrollments.tuition,enrollments.lunch_total, enrollments.registration_fee,enrollments.discount,
				enrollments.total, enrollments.material_fee, enrollments.locations_id,	 students_first_name, students_last_name, sibling_discount,promotion_discount,other_discount
				FROM enrollments,   customers, families, students
				WHERE enrollments.customers_id = customers.customers_id
				AND enrollments.students_id = students.students_id
				AND families.families_id = customers.families_id
				AND families.families_id = students.families_id 
				and (enrollments_status ='Processing' or enrollments_status='Cart Processing' or enrollments_status='Accepted')
				and enrollment_date  <='".$end_date."'
				AND enrollment_date >='".$start_date."'
				and enrollments.customers_id=".$customers_id;
		 }

		$query=tep_db_query($sql);	
     while ($info = tep_db_fetch_array($query)) {
		  $array[] = array(
			'enrollments_id' => $info['enrollments_id'],
			'tuition' => $info['tuition'],
			'registration_fee' => $info['registration_fee'],
			'discount' => $info['discount'],
			'lunch_total' => $info['lunch_total'],
			'material_fee' => $info['material_fee'],
			'tuition_paid' => $info['tuition_paid'],
			'locations_id' => $info['locations_id'],
			'students_first_name' => $info['students_first_name'],
			'students_last_name' => $info['students_last_name'],
			'sibling_discount' => $info['sibling_discount'],
			'promotion_discount' => $info['promotion_discount'],
			'other_discount' => $info['other_discount']
			);
	 }
	 return $array;
	}

	function tep_get_family_sibling_discount($customers_id,$year){ // this function is used in cart, on fly discount calculation
	
	//	$start_date=$year.'-01-01';
	//	$start_date=date('Y-m-d',strtotime($start_date));	
	//	$end_date=$year.'-12-31';
	//	$end_date=date('Y-m-d',strtotime($end_date));
		$family_sibling_discount=0;
		$family_tuition_total=0;
		$max_t=0;
		$info_array=tep_get_summer_family_enrollments($customers_id, $year,"Not Draft");
		// get family enrollments list of Accepted/Pending/Processing
	
		  /////////////////////sibling_discount/////////
				
		if(sizeof($info_array)>1){
			   $i=0;
				 foreach ($info_array as $info){				
					 $i=$info['enrollments_id'];
				 $tuition_array[$i]=$info['tuition'];
				 $family_tuition_total+=$info['tuition'];
					//$i++;	 			 
				  }  
					//print_r($tuition_array);
					//$family_tuition_total=array_sum($tuition_array);
					$max_t=max($tuition_array);
				//	echo max(array_keys($tuition_array); // key of max array
					 $family_sibling_discount = ($family_tuition_total-$max_t)*0.05;
				 } 	 
			 	  
	 return $family_sibling_discount;
	
	}
		///////////////// never used set_sibling_discount//////////////////////////
	// may delete
	function set_sibling_discount($enrollments_id,$action){
		$start_date=date('Y-m-d', strtotime('first day of january this year'));
		$material_fee_waived=0;
		$registration_fee_waived=0;
	 $query = tep_db_query("SELECT * FROM enrollments WHERE enrollments_id>'".$enrollments_id);
	  $info = tep_db_fetch_array($query) 	;
	 $students_id=$info['students_id'];
	 $tuition=$info['tuition'];	 
	 
	 if(empty($info)||($students_id==$sid) ){
	 return 0;}
	if(($students_id!=$sid)&&($t<=$tuition)){ 
	 return 0.05;}
	if(($students_id!=$sid)&&($t>$tuition)){ 		
		if($action=="update"||$action=="add"){
		//update silbing enrollment total to .95
		$query = tep_db_query("select * from enrollments where students_id =".$students_id);
      while ($info = tep_db_fetch_array($query)) {
			 $d=$info['tuition']*0.05;
			 $enrollments_id=$info['enrollments_id'];
		// tep_db_query("update enrollments set tuition=".$tuit." where enrollments_id =".$enrollments_id);
		$sql_data_array = array(
                            'enrollments_status' => 'Cart Processing',
							'total'=>$info['tuition'],
							'sibling_discount'=>$d,
							'material_fee_waived'=>$material_fee_waived,
							'registration_fee_waived'=>$registration_fee_waived,
							'last_modified'	=> date("Y-m-d H:i:s")								
								);
		  tep_db_perform('enrollments', $sql_data_array, 'update', " enrollments_id= '".$enrollments_id . "' 
		  and (enrollments_status= 'Processing' or enrollments_status= 'Cart Processing')");
		
		 //update silbing weekly enrollment tuition to .95  --- not use. weekly total will show original tuition
		/* $query = tep_db_query("select * from summer_enrollments where enrollments_id =".$enrollments_id);
			  while ($info = tep_db_fetch_array($query)) {
				 $summer_enrollments_weekly_total =$info['summer_enrollments_weekly_total ']*0.95;
				 $enrollments_id=$info['enrollments_id'];
			 tep_db_query("update enrollments set summer_enrollments_weekly_total =".$summer_enrollments_weekly_total ." where enrollments_id =".$enrollments_id);
			  }		
				*/			  
		  }
		}
		return 1; 	 
		}
	}
	   
	 function tep_get_summer_classes_enrolled_for_change($summer_class_level_id,$week,$class_period,$locations_id,$year,$class_status='',$enrollments_id){
	 $array = array();  
	 $info_array1= array();
	 $info_array2= array();
	 $flag=0;
	 $info_array1=  tep_get_summer_classes($summer_class_level_id,$week,$class_period, $locations_id,$year,$class_status);
	//print_r($info_array1);

	  $info_array2= tep_get_summer_enrollment($enrollments_id,$week);
	//  print_r($info_array2);
	  
	
	  //1. class available : class_status==Y
	  // add class and id to array
	  
	  //2. class is full: class_status==N
	    //2.1 if class is full, add the class to array
		for($i=0;$i<sizeof($info_array1);$i++){
			$class_info=tep_get_one_summer_class($info_array1[$i]['summer_classes_id']);
			//echo "--dd---".$info_array1[$i]['summer_classes_id']."-".$class_info[0]['class_status']."---ee--<br>";
			  if($class_info[0]['class_status']=="Y"){
					$flag=1;
			  }
			  else if ($class_info[0]['class_status']=="N"){//class is full
				  if($class_period=="Morning"){
					if($info_array1[$i]['summer_classes_id']==$info_array2[0]['summer_sports_id']){
						$flag=1;
					}
					else{
						$flag=0;
					}
				 }
				 else if($class_period=="Afternoon"){
					if($info_array1[$i]['summer_classes_id']==$info_array2[0]['summer_art_classes_id']){
						$flag=1;
					}	
					else{
						$flag=0;
					}					
				 }		  
			  }// end N
			if($flag==1){
			$array[] = array('summer_classes_id' => $info_array1[$i]['summer_classes_id'],
						'summer_class_name' => $info_array1[$i]['summer_class_name'],
						'courses_name' => $info_array1[$i]['courses_name'],
						);
			}
	
		}//end loop
	 
    return $array;
		 }
	
function tep_get_class_enrollment_count($summer_classes_id){
		$year=date('Y');
		$current_year_first_day=$year.'-01-01';
		 $sql="SELECT count(summer_enrollments.enrollments_id)as e 
		FROM summer_enrollments,enrollments 
		WHERE summer_enrollments.enrollments_id= enrollments.enrollments_id and `enrollments_status`='Accepted' 
		and (summer_sports_id=".$summer_classes_id ." or summer_art_classes_id=".$summer_classes_id.")";
	
	 $info = tep_db_fetch_array (tep_db_query($sql));

	  return $info['e'];

	  }
	function tep_check_set_class_status($summer_classes_id){
	
		
		$sql="SELECT *  FROM summer_classes WHERE `summer_classes_id`  ='".$summer_classes_id ."'";

		$info = tep_db_fetch_array (tep_db_query($sql));
		
		$class_status=$info['class_status'];
		 $cap=$info['max_capacity'];
		
		
			if($cap>0&&$cap!=100){
			 $class_enrollment_count=tep_get_class_enrollment_count($summer_classes_id);
			#echo "class ".$summer_classes_id."cap ".$cap." count ".$class_enrollment_count."<br>";
			////// when enroll count>= cap, set class_status ='N'
				if ($class_enrollment_count>=$cap){
				#	echo "###".$summer_classes_id."###";
			
				 $sql_data_array = array(
                            'class_status' => 'N'							
								);
			tep_db_perform('summer_classes', $sql_data_array, 'update', " summer_classes_id= '".$summer_classes_id . "'"); 
				}
			/////////when enroll count<cap and class_status=='N', set class_status='Y'
			else if($class_enrollment_count<$cap && $class_status=='N')	{
				$sql_data_array = array(
                            'class_status' => 'Y'							
								);
			tep_db_perform('summer_classes', $sql_data_array, 'update', " summer_classes_id= '".$summer_classes_id . "'"); 
			}			
			}
			
		
		
		}
 
	  
	  
	   function tep_get_summer_classes_2023($summer_class_levels_id,$grade,$week,$class_period,$locations_id,$year,$class_status=''){
	 $array = array();  
	$classname="";
	/*if($summer_class_levels_id==2)
		$str_summer_class_level=" summer_classes.summer_class_level_id=2 ";
	if($summer_class_levels_id==3)
		$str_summer_class_level=" summer_classes.summer_class_level_id=3 ";
	if($summer_class_levels_id==4)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($summer_class_levels_id==5)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($summer_class_levels_id==6)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";	
	if($summer_class_levels_id==7)
		$str_summer_class_level="  summer_classes.summer_class_level_id=7";
	if($summer_class_levels_id==9)
		$str_summer_class_level=" (summer_classes.summer_class_level_id=6 or summer_classes.summer_class_level_id=7)";
	*/
	if($grade==1)
		$str_summer_class_level=" summer_classes.summer_class_level_id=2 ";
	if($grade==2)
		$str_summer_class_level=" summer_classes.summer_class_level_id=3 ";
	if($grade==3)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($grade==4)
		$str_summer_class_level=" summer_classes.summer_class_level_id=4 ";
	if($grade==5)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";
	if($grade==6)
		$str_summer_class_level=" summer_classes.summer_class_level_id=6 ";	
	if($grade==7)
		$str_summer_class_level=" (summer_classes.summer_class_level_id=6 or summer_classes.summer_class_level_id=7)";
	if($grade>=8)
		$str_summer_class_level=" summer_classes.summer_class_level_id=7";
	
	 if ($class_status=='Y'){
		 $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and class_status='Y' 
and status='Active'
AND ".$str_summer_class_level."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
	 ";}
else{
  $sql="
SELECT summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks, courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and status='Active'
AND ".$str_summer_class_level."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes_id,summer_week_description,courses_name, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
 ORDER BY summer_classes.`summer_class_level_id` 
";
}

 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
	if($summer_class_levels_id==9)
		$classname= $info['summer_class_name']." (".$info['summer_class_level'].")";
	else
		$classname= $info['summer_class_name'];
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $classname,
						'courses_name' => $info['courses_name'],						
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						//'class_status' => $info['class_status'],						
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
           
 function tep_get_summer_classes_enrolled_for_change_2023($summer_class_level_id,$grade,$week,$class_period,$locations_id,$year,$class_status='',$enrollments_id){
	 $array = array();  
	 $info_array1= array();
	 $info_array2= array();
	 $flag=0;

	//tep_get_summer_classes_2023($summer_class_levels_id,$grade,$week,$class_period,$locations_id,$year,$class_status='')
	 $info_array1=  tep_get_summer_classes_2023($summer_class_level_id,$grade,$week,$class_period, $locations_id,$year,$class_status);
	//print_r($info_array1);

	  $info_array2= tep_get_summer_enrollment($enrollments_id,$week);
	//  print_r($info_array2);
	  
	
	  //1. class available : class_status==Y
	  // add class and id to array
	  
	  //2. class is full: class_status==N
	    //2.1 if class is full, add the class to array
		for($i=0;$i<sizeof($info_array1);$i++){
			$class_info=tep_get_one_summer_class($info_array1[$i]['summer_classes_id']);
			//echo "--dd---".$info_array1[$i]['summer_classes_id']."-".$class_info[0]['class_status']."---ee--<br>";
			  if($class_info[0]['class_status']=="Y"){
					$flag=1;
			  }
			  else if ($class_info[0]['class_status']=="N"){//class is full
				  if($class_period=="Morning"){
					if($info_array1[$i]['summer_classes_id']==$info_array2[0]['summer_sports_id']){
						$flag=1;
					}
					else{
						$flag=0;
					}
				 }
				 else if($class_period=="Afternoon"){
					if($info_array1[$i]['summer_classes_id']==$info_array2[0]['summer_art_classes_id']){
						$flag=1;
					}	
					else{
						$flag=0;
					}					
				 }		  
			  }// end N
			if($flag==1){
			$array[] = array('summer_classes_id' => $info_array1[$i]['summer_classes_id'],
						'summer_class_name' => $info_array1[$i]['summer_class_name'],
						'courses_name' => $info_array1[$i]['courses_name'],
						);
			}
	
		}//end loop
	 
    return $array;
		 }
		 
	 function tep_get_summer_enrollment_2023($enrollments_id,$week=''){
	 $array = array();
	 if($week==""){
		 $sql="select * from summer_enrollments
	  where  enrollments_id=".$enrollments_id;
	 }else{
		$sql="select * from summer_enrollments
	  where  enrollments_id=".$enrollments_id." and summer_week=".$week;
	 }
	 
      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_programs_id' => $info['summer_programs_id'],
						'summer_class_levels_id' => $info['summer_class_levels_id'],
						'summer_class_level' => $info['summer_class_level'],
						'weekly_tuition' => $info['weekly_tuition'],
						'summer_enrollments_weekly_total' => $info['summer_enrollments_weekly_total'],
						'days_in_week' => $info['days_in_week'],
						'summer_sports_id' => $info['summer_sports_id'],
						'morning_session' => $info['morning_session'],
						'summer_art_classes_id' => $info['summer_art_classes_id'],
						'aftercamp1' => $info['aftercamp1'],
						'aftercamp1_session' => $info['aftercamp1_session'],
						'aftercamp2' => $info['aftercamp2'],
						'aftercamp2_session' => $info['aftercamp2_session'],
						'aftercamp3' => $info['aftercamp3'],
						'aftercamp3_session' => $info['aftercamp3_session'],
						'summer_week' => $info['summer_week'],
						'lunch' => $info['lunch'],
						'weekly_tuition' => $info['weekly_tuition'],
						'summer_afternoon_classes' => $info['summer_art_classes_id'],
						'summer_language_class' => $info['summer_language_class'],
						'morning_session' => $info['morning_session'],	
						'afternoon_session' => $info['afternoon_session'],	
						'summer_morning_classes' => $info['summer_sports_id'],
						'locations_id' => $info['locations_id']
						);
      }
    return $array;
	}
	
	  function tep_get_friends_requests($enrollments_id){
	 $array = array();
	
	 $sql="select * from enrolllments_friend_requests where enrollments_id=".$enrollments_id;

	      $query = tep_db_query($sql);
      while ($info = tep_db_fetch_array($query)) {
        $array[] = array('friend_requests_id' => $info['friend_requests_id'],
						'enrollments_id' => $info['enrollments_id'],
						'friends_names' => $info['friends_names'],
						'input_time' => $info['input_time'],
						'input_user' => $info['input_user']
						);
      }
	 
    return $array;
		 }
	/* function tep_get_orders_family_sibling_discount($customers_id,$year){
		//$year=date('Y');
		$current_year_first_day=$year.'-01-01';
		 $sql="SELECT orders.orders_id, family_sibling_discount,date_purchased, orders_status,total FROM `orders_sibling_discounts`,orders 
		WHERE orders_sibling_discounts.orders_id=orders.orders_id 
		and (orders_status='Payment Completed' or orders_status='Card Payment Completed')
		and date_purchased >='".$current_year_first_day."'
		and customers_id=".$customers_id;
		
	 $query=tep_db_query($sql);
	   while ($info = tep_db_fetch_array($query)) {
		  $array[] = array(
			'orders_id' => $info['orders_id'],
			'family_sibling_discount' => $info['family_sibling_discount'],
			'date_purchased' => $info['date_purchased'],
			'orders_status' => $info['orders_status'],
			'customers_id' => $info['customers_id'],
			'total' => $info['total'],
			
			);
	 }
	 return $array;

	  }*/
	/////////////////// deleted 2020/////////////////
	/*    function tep_get_action_logs($customer_id) {

	global $customer_id;
    if ( tep_session_is_registered('customer_id')){
	$array= array();
 "SELECT * FROM `action_logs` WHERE customers_id='" . (int)$customer_id ."'";
    $query = tep_db_query("SELECT * FROM `action_logs` WHERE customers_id='" . (int)$customer_id ."'");
	 while ($values = tep_db_fetch_array($query)) {
		  $array[] = array(
		  'logs_id' => $values['logs_id'],
		  'administrators_id' => $values['administrators_id'],
		  'change_datetime' => $values['change_datetime'],
		  'notes' => $values['notes'],
		  'customers_signature' => $values['customers_signature'],
		  'page' => $values['page']
		  );
	 }
	  return $array;
	}
	}
	*/
	///////////////////////////////////////////////////////////////
	//////////////// New or updated Functions 2019 //////////////////////////
	///////////////////////////////////////////////////////////////
	
	// combine summmer_sports & summer_art_classes
	// get morning or afternoon classes. $class_period (Morning or Afternoon)
/*	 function tep_get_summer_classes_2019($summer_class_level_id,$week,$class_period,$locations_id,$year){
	 $array = array();

// if ($summer_class_levels_id==8){
 //$sql="SELECT summer_classes_id,summer_class_name FROM summer_classes WHERE summer_week='".$week ."' and locations_id='".$locations_id."' 
 //and class_period='".$class_period ."'    and year='".$year."' and class_status='Y'  group by summer_classes_id,summer_class_name";
 //}else{

  $sql="
SELECT summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
AND summer_classes.`summer_week` =".$week."
and class_status='Y' 
and status='Active'
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
ORDER BY summer_classes.`summer_class_level_id` 
";

 //}   
 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
	
////////////////should combine with tep_get_summer_classes()//////////////////

	 function tep_get_summer_classes_all_2019($summer_class_level_id,$week,$class_period,$locations_id,$year){
	 $array = array();

// if ($summer_class_levels_id==8){
 //$sql="SELECT summer_classes_id,summer_class_name FROM summer_classes WHERE summer_week='".$week ."' and locations_id='".$locations_id."' 
 //and class_period='".$class_period ."'    and year='".$year."' and class_status='Y'  group by summer_classes_id,summer_class_name";
 //}else{

   $sql="
SELECT summer_classes.summer_classes_id, summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`

and status='Active'
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_classes.summer_classes_id,summer_week_description, summer_classes.`summer_week` , `summer_class_name` , `summer_class_level` 
ORDER BY summer_classes.`summer_class_level_id` 
";

 //}   
 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
	 */
	////////////////should combine with tep_get_summer_classes()//////////////////

/*	 function tep_get_summer_classes_all($summer_class_level_id,$week,$class_period,$locations_id,$year){
	 $array = array();

// if ($summer_class_levels_id==8){
 //$sql="SELECT summer_classes_id,summer_class_name FROM summer_classes WHERE summer_week='".$week ."' and locations_id='".$locations_id."' 
 //and class_period='".$class_period ."'    and year='".$year."' and class_status='Y'  group by summer_classes_id,summer_class_name";
 //}else{

  $sql="
SELECT  summer_week_description, summer_classes.`summer_week` , courses_name as `summer_class_name` , `summer_class_level` 
FROM summer_classes, summer_class_levels, summer_weeks,courses
WHERE summer_classes.year =".$year."
AND class_period =  '".$class_period."'
and summer_classes.courses_id=courses.courses_id
AND summer_weeks.summer_week = summer_classes.`summer_week` 
and summer_weeks.summer_year= summer_classes.`year` 
and summer_weeks.locations_id= summer_classes.`locations_id` 
AND summer_class_levels.summer_class_level_id = summer_classes.`summer_class_level_id`
and status='Active'
AND summer_classes.`summer_week` =".$week."
AND summer_classes.`summer_class_level_id` =".$summer_class_level_id."
and summer_classes.locations_id=".$locations_id."
GROUP BY summer_week_description, summer_classes.`summer_week` , courses_name , `summer_class_level` 
ORDER BY summer_classes.`summer_class_level_id` 
";

 //}   
 $query = tep_db_query($sql);
 //if($class_period=="Aftercamp1"||$class_period=="Aftercamp2"||$class_period=="Aftercamp3"){
	// if(tep_db_num_rows($query)>1)
 //echo "**";}

 while ($info = tep_db_fetch_array($query)) {
        $array[] = array('summer_classes_id' => $info['summer_classes_id'],
						'summer_class_name' => $info['summer_class_name'],
						'summer_week' => $info['summer_week'],
						'class_period' => $info['class_period'],
						'class_description' => $info['class_description'],
						'addon_status' => $info['addon_status'],
						'summer_class_level_id 	' => $info['summer_classes.summer_class_level_id'],
						'summer_week_description' => $info['summer_week_description'],
											
						);
      }
    return $array;
		 }
		 
		 		//check_set_availability($date)

	function check_capacity($summer_classes_id,$summer_day_id){
		$sql="SELECT max_capacity  FROM summer_classes WHERE `summer_classes_id`  ='".$summer_classes_id ."'";

		$info = tep_db_fetch_array (tep_db_query($sql));

		 $cap=$info['max_capacity'];
	
		 $daily_enrollment_count=tep_get_daily_enrollment_count($summer_classes_id,$summer_day_id);

		if ($daily_enrollment_count<=$cap)
		 return $cap-$daily_enrollment_count;
		 else
		 return 0;

		}
		  //daily_enrollment_count

    function tep_get_daily_enrollment_count($summer_classes_id,$summer_day_id){
		$year=date('Y');
		$current_year_first_day=$year.'-01-01';;
		 $sql="SELECT count(summer_enrollments.enrollments_id)as e 
		FROM summer_enrollments_schedules,enrollments,summer_enrollments 
		 WHERE summer_enrollments_schedules.enrollments_id=enrollments.enrollments_id 
		and summer_enrollments.enrollments_id=enrollments.enrollments_id 
		and (enrollments_status='Accepted' or enrollments_status='Processing' or enrollments_status='Cart Processing') 
		and (`summer_sports_id`='".$summer_classes_id ."' or `summer_art_classes_id`='".$summer_classes_id ."')
		and enrollment_date>='".$current_year_first_day."'
		and summer_day_id  ='".$summer_day_id ."'";
	 $info = tep_db_fetch_array (tep_db_query($sql));

	  return $info['e'];

	  }
	     function tep_get_weekly_enrollment_count($summer_classes_id,$summer_day_id){
		$year=date('Y');
		$current_year_first_day=$year.'-01-01';;
		 $sql="SELECT count(summer_enrollments.enrollments_id)as e 
		FROM summer_enrollments_schedules,enrollments,summer_enrollments 
		 WHERE summer_enrollments_schedules.enrollments_id=enrollments.enrollments_id 
		and summer_enrollments.enrollments_id=enrollments.enrollments_id 
		and (enrollments_status='Accepted' or enrollments_status='Processing' or enrollments_status='Cart Processing') 
		and (`summer_sports_id`='".$summer_classes_id ."' or `summer_art_classes_id`='".$summer_classes_id ."')
		and enrollment_date>='".$current_year_first_day."'
		and summer_day_id  ='".$summer_day_id ."'";
	 $info = tep_db_fetch_array (tep_db_query($sql));

	  return $info['e'];

	  }
	  
		 */
		 function tep_get_first_enrolled_day($enrollments_id){
			 
		 }
	?>